/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.gpp.GppClosureParameterTypeProvider;
import org.jetbrains.plugins.groovy.gpp.GppTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GppReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(GrArgumentLabel.class), new PsiReferenceProvider(){

            public PsiReference[] getReferencesByElement(PsiElement element, ProcessingContext context) {
                PsiElement parent = element.getParent();
                if (parent instanceof GrNamedArgument && parent.getParent() instanceof GrListOrMap) {
                    return new PsiReference[]{new GppMapMemberReference(element)};
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }

    public static class GppMapMemberReference
    extends PsiReferenceBase.Poly<GrArgumentLabel> {
        public GppMapMemberReference(PsiElement element) {
            super((PsiElement)((GrArgumentLabel)element));
        }

        public boolean isReferenceTo(PsiElement element) {
            return element instanceof PsiMethod && super.isReferenceTo(element);
        }

        public ResolveResult[] multiResolve(boolean incompleteCode) {
            PsiClass psiClass;
            GrArgumentLabel context = (GrArgumentLabel)this.getElement();
            GrNamedArgument namedArgument = (GrNamedArgument)context.getParent();
            GrExpression map = (GrExpression)namedArgument.getParent();
            PsiClassType classType = LiteralConstructorReference.getTargetConversionType(map);
            if (classType != null && (psiClass = classType.resolve()) != null) {
                LiteralConstructorReference reference;
                GrExpression value = namedArgument.getExpression();
                List<ResolveResult> applicable = this.addMethodCandidates(classType, value);
                String memberName = this.getValue();
                if ("super".equals(memberName) && GppTypeConverter.hasTypedContext(this.myElement) && (reference = (LiteralConstructorReference)map.getReference()) != null && reference.getConstructedClassType() != null) {
                    return reference.multiResolve(incompleteCode);
                }
                if (value == null || applicable.isEmpty()) {
                    PsiMethod setter = PropertyUtil.findPropertySetter((PsiClass)psiClass, (String)memberName, (boolean)false, (boolean)true);
                    if (setter != null) {
                        applicable.add((ResolveResult)new PsiElementResolveResult((PsiElement)setter));
                    } else {
                        PsiField field = PropertyUtil.findPropertyField((PsiClass)psiClass, (String)memberName, (boolean)false);
                        if (field != null) {
                            applicable.add((ResolveResult)new PsiElementResolveResult((PsiElement)field));
                        }
                    }
                }
                return applicable.toArray(new ResolveResult[applicable.size()]);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private List<ResolveResult> addMethodCandidates(PsiClassType classType, GrExpression value) {
            PsiType valueType = value == null ? null : value.getType();
            ArrayList applicable = ContainerUtil.newArrayList();
            if (value == null || GroovyPsiManager.isInheritorCached(valueType, "groovy.lang.Closure")) {
                ArrayList byName = ContainerUtil.newArrayList();
                for (Pair<PsiMethod, PsiSubstitutor> variant : GppClosureParameterTypeProvider.getMethodsToOverrideImplementInInheritor(classType, false)) {
                    PsiType[] psiTypes;
                    PsiMethod method = (PsiMethod)variant.first;
                    if (!this.getValue().equals(method.getName())) continue;
                    PsiElementResolveResult resolveResult = new PsiElementResolveResult((PsiElement)method);
                    byName.add(resolveResult);
                    if (!(valueType instanceof GrClosureType) || !GppTypeConverter.isClosureOverride(psiTypes = GppClosureParameterTypeProvider.getParameterTypes(variant), (GrClosureType)valueType, (GroovyPsiElement)this.myElement)) continue;
                    applicable.add(resolveResult);
                }
                if (applicable.isEmpty()) {
                    return byName;
                }
            }
            return applicable;
        }

        public Object[] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

