/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.base;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.template.expressions.ParameterNameExpression;

public class IntentionUtils {
    private static final Logger LOG = Logger.getInstance(IntentionUtils.class);

    public static void createTemplateForMethod(PsiType[] argTypes, ChooseTypeExpression[] paramTypesExpressions, PsiMethod method, PsiClass owner, TypeConstraint[] constraints, boolean isConstructor, final PsiElement context) {
        final Project project = owner.getProject();
        PsiTypeElement typeElement = method.getReturnTypeElement();
        ChooseTypeExpression expr = new ChooseTypeExpression(constraints, PsiManager.getInstance((Project)project), context.getResolveScope(), method.getLanguage() == GroovyLanguage.INSTANCE);
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method);
        if (!isConstructor) {
            assert (typeElement != null);
            builder.replaceElement((PsiElement)typeElement, (Expression)expr);
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        assert (parameters.length == argTypes.length);
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiTypeElement parameterTypeElement = parameter.getTypeElement();
            builder.replaceElement((PsiElement)parameterTypeElement, (Expression)paramTypesExpressions[i]);
            builder.replaceElement((PsiElement)parameter.getNameIdentifier(), (Expression)new ParameterNameExpression(null));
        }
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            PsiJavaToken lbrace = body.getLBrace();
            assert (lbrace != null);
            builder.setEndVariableAfter((PsiElement)lbrace);
        } else {
            builder.setEndVariableAfter((PsiElement)method.getParameterList());
        }
        method = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
        Template template = builder.buildTemplate();
        final PsiFile targetFile = owner.getContainingFile();
        final Editor newEditor = IntentionUtils.positionCursor(project, targetFile, (PsiElement)method);
        TextRange range = method.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        TemplateEditingAdapter templateListener = new TemplateEditingAdapter(){

            public void templateFinished(Template template, boolean brokenOff) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiTypeParameter[] typeParameters;
                        PsiDocumentManager.getInstance((Project)project).commitDocument(newEditor.getDocument());
                        int offset = newEditor.getCaretModel().getOffset();
                        PsiMethod method = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)targetFile, (int)(offset - 1), PsiMethod.class, (boolean)false);
                        if (context instanceof PsiMethod && (typeParameters = ((PsiMethod)context).getTypeParameters()).length > 0) {
                            for (PsiTypeParameter typeParameter : typeParameters) {
                                if (!CreateMethodFromUsageFix.checkTypeParam((PsiMethod)method, (PsiTypeParameter)typeParameter)) continue;
                                JVMElementFactory factory = JVMElementFactories.getFactory((Language)method.getLanguage(), (Project)method.getProject());
                                PsiTypeParameterList list = method.getTypeParameterList();
                                if (list == null) {
                                    PsiTypeParameterList newList = factory.createTypeParameterList();
                                    list = (PsiTypeParameterList)method.addAfter((PsiElement)newList, (PsiElement)method.getModifierList());
                                }
                                list.add((PsiElement)factory.createTypeParameter(typeParameter.getName(), typeParameter.getExtendsList().getReferencedTypes()));
                            }
                        }
                        if (method != null) {
                            try {
                                boolean hasNoReturnType;
                                boolean bl = hasNoReturnType = method.getReturnTypeElement() == null && method instanceof GrMethod;
                                if (hasNoReturnType) {
                                    ((GrMethod)method).setReturnType((PsiType)PsiType.VOID);
                                }
                                if (method.getBody() != null) {
                                    FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
                                    FileTemplate fileTemplate = templateManager.getCodeTemplate("Groovy New Method Body.groovy");
                                    PsiClass containingClass = method.getContainingClass();
                                    LOG.assertTrue(!containingClass.isInterface() || GrTraitUtil.isTrait(containingClass), (Object)"Interface bodies should be already set up");
                                    CreateFromUsageUtils.setupMethodBody((PsiMethod)method, (PsiClass)containingClass, (FileTemplate)fileTemplate);
                                }
                                if (hasNoReturnType) {
                                    ((GrMethod)method).setReturnType(null);
                                }
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                            CreateFromUsageUtils.setupEditor((PsiMethod)method, (Editor)newEditor);
                        }
                    }
                });
            }
        };
        manager.startTemplate(newEditor, template, (TemplateEditingListener)templateListener);
    }

    public static Editor positionCursor(Project project, PsiFile targetFile, PsiElement element) {
        int textOffset = element.getTextOffset();
        VirtualFile virtualFile = targetFile.getVirtualFile();
        if (virtualFile != null) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, textOffset);
            return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
        return null;
    }
}

