/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.MutablyNamedIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ComparisonPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;

public class FlipComparisonIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        String flippedComparison;
        GrBinaryExpression binaryExpression = (GrBinaryExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        String comparison = ComparisonUtils.getStringForComparison(tokenType);
        if (comparison.equals(flippedComparison = ComparisonUtils.getFlippedComparison(tokenType))) {
            return GroovyIntentionsBundle.message("flip.smth.intention.name", comparison);
        }
        return GroovyIntentionsBundle.message("flip.comparison.intention.name", comparison, flippedComparison);
    }

    @Override
    public PsiElementPredicate getElementPredicate() {
        return new ComparisonPredicate();
    }

    @Override
    public void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        GrBinaryExpression exp = (GrBinaryExpression)element;
        IElementType tokenType = exp.getOperationTokenType();
        GrExpression lhs = exp.getLeftOperand();
        String lhsText = lhs.getText();
        GrExpression rhs = exp.getRightOperand();
        String rhsText = rhs.getText();
        String flippedComparison = ComparisonUtils.getFlippedComparison(tokenType);
        String newExpression = rhsText + flippedComparison + lhsText;
        PsiImplUtil.replaceExpression(newExpression, exp);
    }
}

