/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class FlipIfIntention
extends Intention {
    @Override
    protected void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        GrIfStatement ifStatement = (GrIfStatement)DefaultGroovyMethods.asType((Object)element.getParent(), GrIfStatement.class);
        GrIfStatement elseIf = FlipIfIntention.getElseIf(ifStatement);
        GrIfStatement elseIfCopy = (GrIfStatement)DefaultGroovyMethods.asType((Object)elseIf.copy(), GrIfStatement.class);
        elseIf.getCondition().replaceWithExpression(ifStatement.getCondition(), true);
        elseIf.getThenBranch().replaceWithStatement(ifStatement.getThenBranch());
        ifStatement.getCondition().replaceWithExpression(elseIfCopy.getCondition(), true);
        ifStatement.getThenBranch().replaceWithStatement(elseIfCopy.getThenBranch());
    }

    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!element.getNode().getElementType().equals(GroovyTokenTypes.kIF)) {
                    return false;
                }
                if (!(element.getParent() instanceof GrIfStatement)) {
                    return false;
                }
                GrIfStatement ifStatement = (GrIfStatement)DefaultGroovyMethods.asType((Object)element.getParent(), GrIfStatement.class);
                GrIfStatement elseIf = FlipIfIntention.getElseIf(ifStatement);
                return elseIf != null && FlipIfIntention.checkIf(ifStatement) && FlipIfIntention.checkIf(elseIf);
            }
        };
    }

    private static GrIfStatement getElseIf(GrIfStatement ifStatement) {
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch == null) {
            return null;
        }
        if (elseBranch instanceof GrIfStatement) {
            return (GrIfStatement)DefaultGroovyMethods.asType((Object)elseBranch, GrIfStatement.class);
        }
        return null;
    }

    private static boolean checkIf(GrIfStatement ifStatement) {
        return ifStatement.getCondition() != null && ifStatement.getThenBranch() != null;
    }
}

