/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.MergeElseIfPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class MergeElseIfIntention
extends Intention {
    @Override
    public PsiElementPredicate getElementPredicate() {
        return new MergeElseIfPredicate();
    }

    @Override
    public void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        GrIfStatement parentStatement = (GrIfStatement)element;
        GrBlockStatement elseBlockStatement = (GrBlockStatement)parentStatement.getElseBranch();
        assert (elseBlockStatement != null);
        GrOpenBlock elseBranch = elseBlockStatement.getBlock();
        GrStatement elseBranchContents = elseBranch.getStatements()[0];
        PsiImplUtil.replaceStatement("if(" + parentStatement.getCondition().getText() + ")" + parentStatement.getThenBranch().getText() + "else " + elseBranchContents.getText(), parentStatement);
    }
}

