/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class ReplaceTernaryWithIfElseIntention
extends Intention {
    @Override
    protected void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        GrConditionalExpression parentTernary = ReplaceTernaryWithIfElseIntention.findTernary(element);
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(project);
        GrReturnStatement parentReturn = (GrReturnStatement)parentTernary.getParent();
        String condition = parentTernary.getCondition().getText();
        GrExpression thenBranch = parentTernary.getThenBranch();
        String thenText = thenBranch != null ? thenBranch.getText() : "";
        GrExpression elseBranch = parentTernary.getElseBranch();
        String elseText = elseBranch != null ? elseBranch.getText() : "";
        String text = "if (" + condition + ") { \nreturn " + thenText + "\n} else {\n return " + elseText + "\n}";
        GrIfStatement ifStatement = (GrIfStatement)groovyPsiElementFactory.createStatementFromText(text);
        ifStatement = parentReturn.replaceWithStatement(ifStatement);
        editor.getCaretModel().moveToOffset(ifStatement.getRParenth().getTextRange().getEndOffset());
    }

    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                GrConditionalExpression ternary = ReplaceTernaryWithIfElseIntention.findTernary(element);
                if (ternary == null || element == null || ternary.getThenBranch() == null || ternary.getElseBranch() == null) {
                    return false;
                }
                return ternary.getParent() instanceof GrReturnStatement;
            }
        };
    }

    private static GrConditionalExpression findTernary(PsiElement element) {
        GrReturnStatement ret;
        GrConditionalExpression ternary = (GrConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)element, GrConditionalExpression.class);
        if (ternary == null && (ret = (GrReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GrReturnStatement.class)) != null && ret.getReturnValue() instanceof GrConditionalExpression) {
            ternary = (GrConditionalExpression)ret.getReturnValue();
        }
        return ternary;
    }
}

