/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;

public abstract class GrChangeMemberVisibilityModifierBase
extends Intention {
    private final String myModifier;

    public GrChangeMemberVisibilityModifierBase(String modifier) {
        this.myModifier = modifier;
    }

    @Override
    protected void processIntention(PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrMember)) {
            return;
        }
        ((GrMember)parent).getModifierList().setModifierProperty(this.myModifier, true);
    }

    @Override
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiElement parent = element.getParent();
                return parent instanceof GrMember && parent instanceof GrNamedElement && (((GrNamedElement)parent).getNameIdentifierGroovy() == element || ((GrMember)parent).getModifierList() == element) && ((GrMember)parent).getModifierList() != null && !((GrMember)parent).getModifierList().hasExplicitModifier(GrChangeMemberVisibilityModifierBase.this.myModifier);
            }
        };
    }
}

