/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class AddReturnTypeFix
implements IntentionAction {
    public String getText() {
        return GroovyIntentionsBundle.message("add.return.type", new Object[0]);
    }

    public String getFamilyName() {
        return GroovyIntentionsBundle.message("add.return.type.to.method.declaration", new Object[0]);
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        if (editor == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        GrMethod method = AddReturnTypeFix.findMethod(file, offset);
        if (method == null && offset > 0) {
            method = AddReturnTypeFix.findMethod(file, offset - 1);
        }
        return method != null && !method.isConstructor();
    }

    private static GrMethod findMethod(PsiFile file, int offset) {
        PsiElement at = file.findElementAt(offset);
        if (at == null) {
            return null;
        }
        if (at.getParent() instanceof GrReturnStatement) {
            GrTypeElement returnTypeElement;
            GrReturnStatement returnStatement = (GrReturnStatement)at.getParent();
            PsiElement word = returnStatement.getReturnWord();
            if (!word.getTextRange().contains(offset)) {
                return null;
            }
            GroovyPsiElement returnOwner = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{GrClosableBlock.class, GrMethod.class});
            if (returnOwner instanceof GrMethod && (returnTypeElement = ((GrMethod)returnOwner).getReturnTypeElementGroovy()) == null) {
                return (GrMethod)returnOwner;
            }
            return null;
        }
        GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)at, GrMethod.class, (boolean)false, (Class[])new Class[]{GrTypeDefinition.class, GrClosableBlock.class});
        if (method != null && GrHighlightUtil.getMethodHeaderTextRange(method).contains(offset) && method.getReturnTypeElementGroovy() == null) {
            return method;
        }
        return null;
    }

    public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        GrMethod method = AddReturnTypeFix.findMethod(file, editor.getCaretModel().getOffset());
        if (method == null) {
            return;
        }
        PsiType type = method.getInferredReturnType();
        if (type == null) {
            type = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)file.getResolveScope());
        }
        type = TypesUtil.unboxPrimitiveTypeWrapper(type);
        GrReferenceAdjuster.shortenAllReferencesIn(method.setReturnType(type));
    }

    public boolean startInWriteAction() {
        return true;
    }
}

