/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public class GrDocCommentImpl
extends LazyParseablePsiElement
implements GrDocComment {
    public GrDocCommentImpl(CharSequence text) {
        super((IElementType)GroovyDocElementTypes.GROOVY_DOC_COMMENT, text);
    }

    public String toString() {
        return "GrDocComment";
    }

    public IElementType getTokenType() {
        return this.getElementType();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitDocComment(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(visitor);
        }
    }

    @Override
    public GrDocCommentOwner getOwner() {
        return GrDocCommentUtil.findDocOwner(this);
    }

    @Override
    public GrDocTag[] getTags() {
        GrDocTag[] tags = (GrDocTag[])PsiTreeUtil.getChildrenOfType((PsiElement)this, GrDocTag.class);
        return tags == null ? GrDocTag.EMPTY_ARRAY : tags;
    }

    @Override
    public GrDocTag findTagByName(@NonNls String name) {
        if (!this.getText().contains(name)) {
            return null;
        }
        for (PsiElement e = this.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!(e instanceof GrDocTag) || !((GrDocTag)e).getName().equals(name)) continue;
            return (GrDocTag)e;
        }
        return null;
    }

    @Override
    public GrDocTag[] findTagsByName(@NonNls String name) {
        if (!this.getText().contains(name)) {
            return GrDocTag.EMPTY_ARRAY;
        }
        ArrayList<GrDocTag> list = new ArrayList<GrDocTag>();
        for (PsiElement e = this.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!(e instanceof GrDocTag) || !name.equals(((GrDocTag)e).getName())) continue;
            list.add((GrDocTag)e);
        }
        return list.toArray(new GrDocTag[list.size()]);
    }

    public PsiElement[] getDescriptionElements() {
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode node = child.getNode();
            if (node == null) continue;
            IElementType i = node.getElementType();
            if (i == GroovyDocElementTypes.GDOC_TAG) break;
            if (i == GroovyDocTokenTypes.mGDOC_COMMENT_START || i == GroovyDocTokenTypes.mGDOC_COMMENT_END || i == GroovyDocTokenTypes.mGDOC_ASTERISKS) continue;
            array.add(child);
        }
        return PsiUtilCore.toPsiElementArray(array);
    }
}

