/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GroovyDocPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;

public abstract class GrDocMemberReferenceImpl
extends GroovyDocPsiElementImpl
implements GrDocMemberReference {
    public GrDocMemberReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    public GrDocReferenceElement getReferenceHolder() {
        return (GrDocReferenceElement)this.findChildByClass(GrDocReferenceElement.class);
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getManager().areElementsEquivalent(element, this.resolve());
    }

    public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
        if (this.isReferenceTo(element)) {
            return this;
        }
        if (element instanceof PsiClass) {
            GrDocReferenceElement holder = this.getReferenceHolder();
            if (holder != null) {
                return this.replace(holder.getReferenceElement().bindToElement(element).getParent());
            }
            GrDocReferenceElement ref = GroovyPsiElementFactory.getInstance(this.getProject()).createDocReferenceElementFromFQN(((PsiClass)element).getQualifiedName());
            return this.replace(ref);
        }
        if (element instanceof PsiMember) {
            String memberRefText;
            PsiClass clazz = ((PsiMember)element).getContainingClass();
            if (clazz == null) {
                return null;
            }
            String qName = clazz.getQualifiedName();
            if (element instanceof PsiField) {
                memberRefText = ((PsiField)element).getName();
            } else if (element instanceof PsiMethod) {
                PsiParameterList list = ((PsiMethod)element).getParameterList();
                StringBuilder builder = new StringBuilder();
                builder.append(((PsiMethod)element).getName()).append("(");
                PsiParameter[] params = list.getParameters();
                for (int i = 0; i < params.length; ++i) {
                    PsiParameter parameter = params[i];
                    PsiType type = parameter.getType();
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append(type.getPresentableText());
                }
                builder.append(")");
                memberRefText = builder.toString();
            } else {
                return null;
            }
            GrDocMemberReference ref = GroovyPsiElementFactory.getInstance(this.getProject()).createDocMemberReferenceFromText(qName, memberRefText);
            return this.replace(ref);
        }
        return null;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        GrDocTagValueToken nameElement = this.getReferenceNameElement();
        ASTNode node = nameElement.getNode();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createDocMemberReferenceNameFromText(newElementName).getNode();
        assert (newNameNode != null && node != null);
        node.getTreeParent().replaceChild(node, newNameNode);
        return this;
    }

    @Override
    public GrDocTagValueToken getReferenceNameElement() {
        GrDocTagValueToken token = (GrDocTagValueToken)this.findChildByClass(GrDocTagValueToken.class);
        assert (token != null);
        return token;
    }

    public PsiElement getElement() {
        return this;
    }

    public PsiReference getReference() {
        return this;
    }

    public TextRange getRangeInElement() {
        GrDocTagValueToken refNameElement = this.getReferenceNameElement();
        int offsetInParent = refNameElement.getStartOffsetInParent();
        return new TextRange(offsetInParent, offsetInParent + refNameElement.getTextLength());
    }

    public String getCanonicalText() {
        return this.getRangeInElement().substring(this.getElement().getText());
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement getQualifier() {
        return this.getReferenceHolder();
    }

    @NonNls
    public String getReferenceName() {
        return this.getReferenceNameElement().getText();
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 1) {
            return results[0].getElement();
        }
        return null;
    }

    public ResolveResult[] multiResolve(boolean incompleteCode) {
        return this.multiResolveImpl();
    }

    public Object[] getVariants() {
        return PsiElement.EMPTY_ARRAY;
    }

    protected abstract ResolveResult[] multiResolveImpl();
}

