/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic.PathExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class CompoundStringExpression {
    private static final Logger LOG = Logger.getInstance(CompoundStringExpression.class);
    private final PsiBuilder myBuilder;
    private final GroovyParser myParser;
    private final boolean myForRefExpr;
    private final IElementType myBegin;
    private final IElementType myContent;
    private final IElementType myEnd;
    private final IElementType mySimpleLiteral;
    private final GroovyElementType myCompoundLiteral;
    private final String myMessage;

    private CompoundStringExpression(PsiBuilder builder, GroovyParser parser, boolean forRefExpr, IElementType begin, IElementType content, IElementType end, IElementType literal, GroovyElementType compoundLiteral, String message) {
        this.myBuilder = builder;
        this.myParser = parser;
        this.myForRefExpr = forRefExpr;
        this.myBegin = begin;
        this.myContent = content;
        this.myEnd = end;
        this.mySimpleLiteral = literal;
        this.myCompoundLiteral = compoundLiteral;
        this.myMessage = message;
    }

    private boolean parse() {
        boolean hasInjection;
        PsiBuilder.Marker marker = this.myBuilder.mark();
        PsiBuilder.Marker marker2 = this.myBuilder.mark();
        LOG.assertTrue(ParserUtils.getToken(this.myBuilder, this.myBegin));
        if (this.mySimpleLiteral != null && this.myBuilder.getTokenType() == this.myEnd) {
            this.myBuilder.advanceLexer();
            this.finishSimpleLiteral(marker, marker2);
            return true;
        }
        if (this.myBuilder.getTokenType() == this.myContent) {
            PsiBuilder.Marker contentMarker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            if (this.myBuilder.getTokenType() == GroovyTokenTypes.mDOLLAR || this.mySimpleLiteral == null) {
                contentMarker.done((IElementType)GroovyElementTypes.GSTRING_CONTENT);
            } else {
                contentMarker.drop();
            }
        } else {
            this.processContent();
        }
        boolean bl = hasInjection = this.myBuilder.getTokenType() == GroovyTokenTypes.mDOLLAR;
        while (this.myBuilder.getTokenType() == GroovyTokenTypes.mDOLLAR) {
            this.parseInjection();
            this.processContent();
        }
        if (!ParserUtils.getToken(this.myBuilder, this.myEnd)) {
            this.myBuilder.error(this.myMessage);
        }
        if (hasInjection || this.mySimpleLiteral == null) {
            marker2.drop();
            marker.done((IElementType)this.myCompoundLiteral);
        } else {
            this.finishSimpleLiteral(marker, marker2);
        }
        return hasInjection;
    }

    private void processContent() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == this.myContent) {
            this.myBuilder.advanceLexer();
        } else {
            this.myBuilder.mark().done(this.myContent);
        }
        marker.done((IElementType)GroovyElementTypes.GSTRING_CONTENT);
    }

    private void finishSimpleLiteral(PsiBuilder.Marker marker, PsiBuilder.Marker marker2) {
        marker2.done(this.mySimpleLiteral);
        if (this.myForRefExpr) {
            marker.drop();
        } else {
            marker.done((IElementType)GroovyElementTypes.LITERAL);
        }
    }

    private boolean parseInjection() {
        if (this.myBuilder.getTokenType() != GroovyTokenTypes.mDOLLAR) {
            return false;
        }
        PsiBuilder.Marker injection = this.myBuilder.mark();
        ParserUtils.getToken(this.myBuilder, GroovyTokenTypes.mDOLLAR);
        if (this.myBuilder.getTokenType() == GroovyTokenTypes.mIDENT || this.myBuilder.getTokenType() == GroovyTokenTypes.kTHIS) {
            PathExpression.parse(this.myBuilder, this.myParser);
        } else if (this.myBuilder.getTokenType() == GroovyTokenTypes.mLCURLY) {
            OpenOrClosableBlock.parseClosableBlock(this.myBuilder, this.myParser);
        } else {
            ParserUtils.wrapError(this.myBuilder, GroovyBundle.message("identifier.or.block.expected", new Object[0]));
        }
        injection.done((IElementType)GroovyElementTypes.GSTRING_INJECTION);
        return true;
    }

    public static boolean parse(PsiBuilder builder, GroovyParser parser, boolean forRefExpr, IElementType begin, IElementType content, IElementType end, IElementType literal, GroovyElementType compoundLiteral, String message) {
        return new CompoundStringExpression(builder, parser, forRefExpr, begin, content, end, literal, compoundLiteral, message).parse();
    }
}

