/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;

class TypeDfaState {
    private final Map<String, DFAType> myVarTypes;

    TypeDfaState() {
        this.myVarTypes = ContainerUtil.newHashMap();
    }

    TypeDfaState(TypeDfaState another) {
        this.myVarTypes = ContainerUtil.newHashMap(another.myVarTypes);
    }

    TypeDfaState mergeWith(TypeDfaState another) {
        if (another.myVarTypes.isEmpty()) {
            return this;
        }
        TypeDfaState state = new TypeDfaState(this);
        state.myVarTypes.putAll(another.myVarTypes);
        return state;
    }

    void joinState(TypeDfaState another, PsiManager manager) {
        for (Map.Entry<String, DFAType> entry : another.myVarTypes.entrySet()) {
            String name = entry.getKey();
            DFAType t1 = entry.getValue();
            if (!this.myVarTypes.containsKey(name)) continue;
            DFAType t2 = this.myVarTypes.get(name);
            if (t1 != null && t2 != null) {
                this.myVarTypes.put(name, DFAType.create(t1, t2, manager));
                continue;
            }
            this.myVarTypes.put(name, null);
        }
    }

    boolean contentsEqual(TypeDfaState another) {
        return ((Object)this.myVarTypes).equals(another.myVarTypes);
    }

    DFAType getVariableType(String variableName) {
        return this.myVarTypes.get(variableName);
    }

    Map<String, PsiType> getBindings(Instruction instruction) {
        HashMap map = ContainerUtil.newHashMap();
        for (Map.Entry<String, DFAType> entry : this.myVarTypes.entrySet()) {
            DFAType value = entry.getValue();
            map.put(entry.getKey(), value == null ? null : value.negate(instruction).getResultType());
        }
        return map;
    }

    void putType(String variableName, DFAType type) {
        this.myVarTypes.put(variableName, type);
    }

    public String toString() {
        return "TypeDfaState{" + this.myVarTypes + '}';
    }

    public boolean containsVariable(String variableName) {
        return this.myVarTypes.containsKey(variableName);
    }

    public void removeBinding(String variableName) {
        this.myVarTypes.remove(variableName);
    }
}

