/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.expectedTypes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class SupertypeConstraint
extends TypeConstraint {
    private final PsiType myDefaultType;

    protected SupertypeConstraint(PsiType type, PsiType defaultType) {
        super(type);
        this.myDefaultType = defaultType;
    }

    @Override
    public boolean satisfied(PsiType type, PsiElement context) {
        return TypesUtil.isAssignableByMethodCallConversion(type, this.getType(), context);
    }

    @Override
    public PsiType getDefaultType() {
        return this.myDefaultType;
    }

    public static SupertypeConstraint create(PsiType type, PsiType defaultType) {
        return new SupertypeConstraint(type, defaultType);
    }

    public static SupertypeConstraint create(PsiType type) {
        return new SupertypeConstraint(type, type);
    }
}

