/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GrAnnotationUtil {
    public static String inferStringAttribute(PsiAnnotation annotation, String attributeName) {
        Object value;
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof PsiLiteral && (value = ((PsiLiteral)targetValue).getValue()) instanceof String) {
            return (String)value;
        }
        return null;
    }

    public static Integer inferIntegerAttribute(PsiAnnotation annotation, String attributeName) {
        Object value;
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof PsiLiteral && (value = ((PsiLiteral)targetValue).getValue()) instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    public static Boolean inferBooleanAttribute(PsiAnnotation annotation, String attributeName) {
        Object value;
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof PsiLiteral && (value = ((PsiLiteral)targetValue).getValue()) instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    public static PsiClass inferClassAttribute(PsiAnnotation annotation, String attributeName) {
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof PsiClassObjectAccessExpression) {
            PsiType type = ((PsiClassObjectAccessExpression)targetValue).getOperand().getType();
            if (type instanceof PsiClassType) {
                return ((PsiClassType)type).resolve();
            }
        } else if (targetValue instanceof GrReferenceExpression) {
            PsiElement resolved;
            GrExpression qualifier;
            if ("class".equals(((GrReferenceExpression)targetValue).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)targetValue).getQualifier()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return (PsiClass)resolved;
            }
            PsiElement resolved2 = ((GrReferenceExpression)targetValue).resolve();
            if (resolved2 instanceof PsiClass) {
                return (PsiClass)resolved2;
            }
        }
        return null;
    }

    public static PsiType extractClassTypeFromClassAttributeValue(PsiAnnotationMemberValue targetValue) {
        if (targetValue instanceof PsiClassObjectAccessExpression) {
            return ((PsiClassObjectAccessExpression)targetValue).getOperand().getType();
        }
        if (targetValue instanceof GrReferenceExpression) {
            PsiElement resolved;
            GrExpression qualifier;
            if ("class".equals(((GrReferenceExpression)targetValue).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)targetValue).getQualifier()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return qualifier.getType();
            }
            PsiElement resolved2 = ((GrReferenceExpression)targetValue).resolve();
            if (resolved2 instanceof PsiClass) {
                return ((GrReferenceExpression)targetValue).getType();
            }
        }
        return null;
    }

    public static PsiElement getActualOwner(GrAnnotation annotation) {
        PsiAnnotationOwner owner = annotation.getOwner();
        if (owner instanceof PsiModifierList) {
            return ((PsiModifierList)owner).getParent();
        }
        return (PsiElement)owner;
    }
}

