/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;

public class GrClassReferenceType
extends PsiClassType {
    private final GrReferenceElement myReferenceElement;

    public GrClassReferenceType(GrReferenceElement referenceElement) {
        super(LanguageLevel.JDK_1_5);
        this.myReferenceElement = referenceElement;
    }

    public GrClassReferenceType(GrReferenceElement referenceElement, LanguageLevel languageLevel) {
        super(languageLevel);
        this.myReferenceElement = referenceElement;
    }

    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    public String getClassName() {
        PsiClass resolved = this.resolve();
        if (resolved != null) {
            return resolved.getName();
        }
        return this.myReferenceElement.getReferenceName();
    }

    public PsiType[] getParameters() {
        return this.myReferenceElement.getTypeArguments();
    }

    public PsiClassType.ClassResolveResult resolveGenerics() {
        final GroovyResolveResult resolveResult = this.myReferenceElement.advancedResolve();
        return new PsiClassType.ClassResolveResult(){

            public PsiClass getElement() {
                PsiElement resolved = resolveResult.getElement();
                return resolved instanceof PsiClass ? (PsiClass)resolved : null;
            }

            public PsiSubstitutor getSubstitutor() {
                return resolveResult.getSubstitutor();
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            public boolean isAccessible() {
                return resolveResult.isAccessible();
            }

            public boolean isStaticsScopeCorrect() {
                return resolveResult.isStaticsOK();
            }

            public PsiElement getCurrentFileResolveScope() {
                return resolveResult.getCurrentFileResolveContext();
            }

            public boolean isValidResult() {
                return this.isStaticsScopeCorrect() && this.isAccessible();
            }
        };
    }

    public PsiClassType rawType() {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myReferenceElement.getProject());
        PsiClass clazz = this.resolve();
        if (clazz != null) {
            return factory.createType(clazz, factory.createRawSubstitutor((PsiTypeParameterListOwner)clazz));
        }
        String qName = this.myReferenceElement.getClassNameText();
        return factory.createTypeByFQClassName(qName, this.myReferenceElement.getResolveScope());
    }

    public String getPresentableText() {
        return PsiNameHelper.getPresentableText((String)this.myReferenceElement.getReferenceName(), (PsiAnnotation[])PsiAnnotation.EMPTY_ARRAY, (PsiType[])this.myReferenceElement.getTypeArguments());
    }

    public String getCanonicalText() {
        return this.myReferenceElement.getCanonicalText();
    }

    public String getInternalCanonicalText() {
        return this.getCanonicalText();
    }

    public boolean isValid() {
        return this.myReferenceElement.isValid();
    }

    public boolean equalsToText(@NonNls String text) {
        return text.endsWith(this.getPresentableText()) && text.equals(this.getCanonicalText());
    }

    public GlobalSearchScope getResolveScope() {
        return this.myReferenceElement.getResolveScope();
    }

    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public PsiClassType setLanguageLevel(LanguageLevel languageLevel) {
        return new GrClassReferenceType(this.myReferenceElement, languageLevel);
    }

    public GrReferenceElement getReference() {
        return this.myReferenceElement;
    }
}

