/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GrMapTypeFromNamedArgs
extends GrMapType {
    private final LinkedHashMap<String, GrExpression> myStringEntries;
    private final List<Couple<GrExpression>> myOtherEntries;
    private final VolatileNotNullLazyValue<List<Couple<PsiType>>> myTypesOfOtherEntries = new VolatileNotNullLazyValue<List<Couple<PsiType>>>(){

        protected List<Couple<PsiType>> compute() {
            return ContainerUtil.map((Collection)GrMapTypeFromNamedArgs.this.myOtherEntries, (Function)new Function<Couple<GrExpression>, Couple<PsiType>>(){

                public Couple<PsiType> fun(Couple<GrExpression> pair) {
                    return Couple.of((Object)GrMapTypeFromNamedArgs.inferTypePreventingRecursion((GrExpression)pair.first), (Object)GrMapTypeFromNamedArgs.inferTypePreventingRecursion((GrExpression)pair.second));
                }
            });
        }
    };
    private final VolatileNotNullLazyValue<LinkedHashMap<String, PsiType>> myTypesOfStringEntries = new VolatileNotNullLazyValue<LinkedHashMap<String, PsiType>>(){

        protected LinkedHashMap<String, PsiType> compute() {
            LinkedHashMap result = ContainerUtil.newLinkedHashMap();
            for (Map.Entry entry : GrMapTypeFromNamedArgs.this.myStringEntries.entrySet()) {
                result.put(entry.getKey(), GrMapTypeFromNamedArgs.inferTypePreventingRecursion((GrExpression)entry.getValue()));
            }
            return result;
        }
    };

    public GrMapTypeFromNamedArgs(PsiElement context, GrNamedArgument[] namedArgs) {
        this(JavaPsiFacade.getInstance((Project)context.getProject()), context.getResolveScope(), namedArgs);
    }

    public GrMapTypeFromNamedArgs(JavaPsiFacade facade, GlobalSearchScope scope, GrNamedArgument[] namedArgs) {
        super(facade, scope);
        this.myStringEntries = ContainerUtil.newLinkedHashMap();
        this.myOtherEntries = ContainerUtil.newArrayList();
        for (GrNamedArgument namedArg : namedArgs) {
            GrArgumentLabel label = namedArg.getLabel();
            GrExpression expression = namedArg.getExpression();
            if (label == null || expression == null) continue;
            String name = label.getName();
            if (name != null) {
                this.myStringEntries.put(name, expression);
                continue;
            }
            if (label.getExpression() == null) continue;
            this.myOtherEntries.add((Couple<GrExpression>)Couple.of((Object)label.getExpression(), (Object)expression));
        }
    }

    @Override
    public PsiType getTypeByStringKey(String key) {
        GrExpression expression = this.myStringEntries.get(key);
        return expression != null ? GrMapTypeFromNamedArgs.inferTypePreventingRecursion(expression) : null;
    }

    @Override
    public Set<String> getStringKeys() {
        return this.myStringEntries.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.myStringEntries.isEmpty() && this.myOtherEntries.isEmpty();
    }

    @Override
    protected PsiType[] getAllKeyTypes() {
        HashSet result = ContainerUtil.newHashSet();
        if (!this.myStringEntries.isEmpty()) {
            result.add(GroovyPsiManager.getInstance(this.myFacade.getProject()).createTypeByFQClassName("java.lang.String", this.getResolveScope()));
        }
        for (Couple<GrExpression> entry : this.myOtherEntries) {
            result.add(GrMapTypeFromNamedArgs.inferTypePreventingRecursion((GrExpression)entry.first));
        }
        result.remove(null);
        return result.toArray(GrMapTypeFromNamedArgs.createArray((int)result.size()));
    }

    @Override
    protected PsiType[] getAllValueTypes() {
        HashSet result = ContainerUtil.newHashSet();
        for (GrExpression grExpression : this.myStringEntries.values()) {
            result.add(GrMapTypeFromNamedArgs.inferTypePreventingRecursion(grExpression));
        }
        for (Couple couple : this.myOtherEntries) {
            result.add(GrMapTypeFromNamedArgs.inferTypePreventingRecursion((GrExpression)couple.second));
        }
        result.remove(null);
        return result.toArray(GrMapTypeFromNamedArgs.createArray((int)result.size()));
    }

    private static PsiType inferTypePreventingRecursion(final GrExpression expression) {
        return (PsiType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)false, (Computable)new Computable<PsiType>(){

            public PsiType compute() {
                return expression.getType();
            }
        });
    }

    @Override
    protected List<Couple<PsiType>> getOtherEntries() {
        return (List)this.myTypesOfOtherEntries.getValue();
    }

    @Override
    protected LinkedHashMap<String, PsiType> getStringEntries() {
        return (LinkedHashMap)this.myTypesOfStringEntries.getValue();
    }

    public boolean isValid() {
        for (GrExpression grExpression : this.myStringEntries.values()) {
            if (grExpression.isValid()) continue;
            return false;
        }
        for (Couple couple : this.myOtherEntries) {
            if (!((GrExpression)couple.first).isValid()) {
                return false;
            }
            if (((GrExpression)couple.second).isValid()) continue;
            return false;
        }
        return true;
    }
}

