/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrRangeType
extends GrLiteralClassType {
    private final PsiType myLeft;
    private final PsiType myRight;
    private final PsiType myIterationType;
    private final String myQualifiedName;
    private final PsiType[] myParameters;

    public GrRangeType(LanguageLevel languageLevel, GlobalSearchScope scope, JavaPsiFacade facade, PsiType left, PsiType right) {
        super(languageLevel, scope, facade);
        this.myLeft = left;
        this.myRight = right;
        this.myIterationType = TypesUtil.boxPrimitiveType(TypesUtil.getLeastUpperBoundNullable(this.myLeft, this.myRight, this.getPsiManager()), this.getPsiManager(), scope);
        this.myQualifiedName = TypesUtil.unboxPrimitiveTypeWrapper(this.myIterationType) == PsiType.INT ? "groovy.lang.IntRange" : "groovy.lang.ObjectRange";
        this.myParameters = this.inferParameters();
    }

    public GrRangeType(GlobalSearchScope scope, JavaPsiFacade facade, PsiType left, PsiType right) {
        this(LanguageLevel.JDK_1_5, scope, facade, left, right);
    }

    @Override
    protected String getJavaClassName() {
        return this.myQualifiedName;
    }

    @Override
    public String getClassName() {
        return StringUtil.getShortName((String)this.myQualifiedName);
    }

    public PsiType[] getParameters() {
        return this.myParameters;
    }

    private PsiType[] inferParameters() {
        if (this.myIterationType == null) {
            return EMPTY_ARRAY;
        }
        PsiClass resolved = this.resolve();
        if (resolved == null || resolved.getTypeParameters().length == 0) {
            return EMPTY_ARRAY;
        }
        return new PsiType[]{this.myIterationType};
    }

    public PsiClassType setLanguageLevel(LanguageLevel languageLevel) {
        return new GrRangeType(languageLevel, this.myScope, this.myFacade, this.myLeft, this.myRight);
    }

    public String getInternalCanonicalText() {
        return "[" + (this.myLeft == null ? "null" : this.myLeft.getInternalCanonicalText()) + ".." + (this.myRight == null ? "null" : this.myRight.getInternalCanonicalText()) + "]";
    }

    public boolean isValid() {
        return !(this.myLeft != null && !this.myLeft.isValid() || this.myRight != null && !this.myRight.isValid());
    }

    public PsiType getIterationType() {
        return this.myIterationType;
    }

    public PsiType getLeft() {
        return this.myLeft;
    }

    public PsiType getRight() {
        return this.myRight;
    }
}

