/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrPsiTypeStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyPsiManager {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager");
    private static final Set<String> ourPopularClasses = ContainerUtil.newHashSet((Object[])new String[]{"groovy.lang.Closure", "groovy.lang.GroovyObject", "groovy.lang.GroovyObjectSupport", "groovy.lang.Script", "java.util.List", "java.util.Collection", "java.lang.String"});
    private static final Ref<PsiClass> EMPTY_REF = new Ref();
    private final Project myProject;
    private final Map<String, GrTypeDefinition> myArrayClass = new HashMap();
    private final ConcurrentMap<GroovyPsiElement, PsiType> myCalculatedTypes = ContainerUtil.createConcurrentWeakMap();
    private final Map<String, Map<GlobalSearchScope, Ref<PsiClass>>> myClassCache = ContainerUtil.createConcurrentSoftValueMap();
    private final ConcurrentMap<PsiMember, Boolean> myCompileStatic = ContainerUtil.newConcurrentMap();
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"groovyPsiManager");
    private static final PsiType UNKNOWN_TYPE = new GrPsiTypeStub();

    public GroovyPsiManager(Project project) {
        this.myProject = project;
        ((PsiManagerEx)PsiManager.getInstance((Project)this.myProject)).registerRunnableToRunOnAnyChange(new Runnable(){

            @Override
            public void run() {
                GroovyPsiManager.this.dropTypesCache();
            }
        });
        ((PsiManagerEx)PsiManager.getInstance((Project)this.myProject)).registerRunnableToRunOnChange(new Runnable(){

            @Override
            public void run() {
                GroovyPsiManager.this.myClassCache.clear();
            }
        });
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                GroovyPsiManager.this.dropTypesCache();
                GroovyPsiManager.this.myClassCache.clear();
            }
        });
    }

    public void dropTypesCache() {
        this.myCalculatedTypes.clear();
        this.myCompileStatic.clear();
    }

    public static boolean isInheritorCached(PsiClass aClass, String baseClassName) {
        if (aClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)GroovyPsiManager.getInstance(aClass.getProject()).findClassWithCache(baseClassName, aClass.getResolveScope()), (boolean)true);
    }

    public static boolean isInheritorCached(PsiType type, String baseClassName) {
        if (type instanceof PsiClassType) {
            return GroovyPsiManager.isInheritorCached(((PsiClassType)type).resolve(), baseClassName);
        }
        return false;
    }

    public static GroovyPsiManager getInstance(Project project) {
        return (GroovyPsiManager)ServiceManager.getService((Project)project, GroovyPsiManager.class);
    }

    public PsiClassType createTypeByFQClassName(String fqName, GlobalSearchScope resolveScope) {
        PsiClass result;
        if (ourPopularClasses.contains(fqName) && (result = this.findClassWithCache(fqName, resolveScope)) != null) {
            return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(result);
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(fqName, resolveScope);
    }

    public boolean isCompileStatic(PsiMember member) {
        Boolean aBoolean = (Boolean)this.myCompileStatic.get(member);
        if (aBoolean == null) {
            aBoolean = (Boolean)ConcurrencyUtil.cacheOrGet(this.myCompileStatic, (Object)member, (Object)this.isCompileStaticInner(member));
        }
        return aBoolean;
    }

    private boolean isCompileStaticInner(PsiMember member) {
        PsiClass aClass;
        PsiModifierList list = member.getModifierList();
        if (list != null) {
            PsiAnnotation compileStatic = list.findAnnotation("groovy.transform.CompileStatic");
            if (compileStatic != null) {
                return GroovyPsiManager.checkForPass(compileStatic);
            }
            PsiAnnotation typeChecked = list.findAnnotation("groovy.transform.TypeChecked");
            if (typeChecked != null) {
                return GroovyPsiManager.checkForPass(typeChecked);
            }
        }
        if ((aClass = member.getContainingClass()) != null) {
            return this.isCompileStatic((PsiMember)aClass);
        }
        return false;
    }

    private static boolean checkForPass(PsiAnnotation annotation) {
        PsiAnnotationMemberValue value = annotation.findAttributeValue("value");
        return value == null || value instanceof PsiReference && ResolveUtil.isEnumConstant((PsiReference)value, "PASS", "groovy.transform.TypeCheckingMode");
    }

    public PsiClass findClassWithCache(String fqName, GlobalSearchScope resolveScope) {
        Ref cached;
        ConcurrentMap map = this.myClassCache.get(fqName);
        if (map == null) {
            map = ContainerUtil.newConcurrentMap();
            this.myClassCache.put(fqName, map);
        }
        if ((cached = (Ref)map.get(resolveScope)) != null) {
            return (PsiClass)cached.get();
        }
        PsiClass result = JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqName, resolveScope);
        map.put(resolveScope, result != null ? Ref.create((Object)result) : EMPTY_REF);
        return result;
    }

    public <T extends GroovyPsiElement> PsiType getType(T element, Function<T, PsiType> calculator) {
        PsiType type = (PsiType)this.myCalculatedTypes.get(element);
        if (type == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            type = (PsiType)calculator.fun(element);
            if (type == null) {
                type = UNKNOWN_TYPE;
            }
            if (stamp.mayCacheNow()) {
                type = (PsiType)ConcurrencyUtil.cacheOrGet(this.myCalculatedTypes, element, (Object)type);
            } else {
                PsiType alreadyInferred = (PsiType)this.myCalculatedTypes.get(element);
                if (alreadyInferred != null) {
                    type = alreadyInferred;
                }
            }
        }
        if (!type.isValid()) {
            GroovyPsiManager.error(element, type);
        }
        return UNKNOWN_TYPE == type ? null : type;
    }

    private static void error(PsiElement element, PsiType type) {
        LOG.error("Type is invalid: " + type + "; element: " + element + " of class " + element.getClass());
    }

    public GrTypeDefinition getArrayClass(PsiType type) {
        String typeText = type.getCanonicalText();
        GrTypeDefinition definition = this.myArrayClass.get(typeText);
        if (definition == null) {
            try {
                definition = GroovyPsiElementFactory.getInstance(this.myProject).createTypeDefinition("class __ARRAY__ { public int length; public " + typeText + "[] clone(){} }");
                this.myArrayClass.put(typeText, definition);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return definition;
    }

    public static PsiType inferType(PsiElement element, Computable<PsiType> computable) {
        List stack = ourGuard.currentStack();
        if (stack.size() > 7) {
            ourGuard.prohibitResultCaching(stack.get(0));
            return null;
        }
        return (PsiType)ourGuard.doPreventingRecursion((Object)element, true, computable);
    }
}

