/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrRenameableLightElement;

public class GroovyTargetElementEvaluator
implements TargetElementEvaluator {
    public static final Key<Object> NAVIGATION_ELEMENT_IS_NOT_TARGET = Key.create((String)"GroovyTargetElementEvaluator.DONT_FOLLOW_NAVIGATION_ELEMENT");

    public boolean includeSelfInGotoImplementation(PsiElement element) {
        return true;
    }

    public PsiElement getElementByReference(PsiReference ref, int flags) {
        PsiElement sourceElement = ref.getElement();
        if (sourceElement instanceof GrCodeReferenceElement) {
            GrNewExpression newExpr;
            if (sourceElement.getParent() instanceof GrNewExpression) {
                newExpr = (GrNewExpression)sourceElement.getParent();
            } else if (sourceElement.getParent().getParent() instanceof GrNewExpression) {
                newExpr = (GrNewExpression)sourceElement.getParent().getParent();
            } else {
                return null;
            }
            PsiMethod constructor = newExpr.resolveMethod();
            GrArgumentList argumentList = newExpr.getArgumentList();
            if (constructor != null && argumentList != null && PsiImplUtil.hasNamedArguments(argumentList) && !PsiImplUtil.hasExpressionArguments(argumentList) && constructor.getParameterList().getParametersCount() == 0) {
                return constructor.getContainingClass();
            }
            return constructor;
        }
        if (sourceElement instanceof GrReferenceExpression) {
            PsiElement resolved = ((GrReferenceExpression)sourceElement).resolve();
            if (resolved instanceof GrGdkMethod || !(resolved instanceof GrRenameableLightElement)) {
                return GroovyTargetElementEvaluator.correctSearchTargets(resolved);
            }
            return resolved;
        }
        return null;
    }

    public static PsiElement correctSearchTargets(PsiElement target) {
        PsiMethod mirror;
        if (target instanceof ClsMethodImpl && (mirror = ((ClsMethodImpl)target).getSourceMirrorMethod()) != null) {
            return mirror.getNavigationElement();
        }
        if (target != null && !(target instanceof GrAccessorMethod) && target.getUserData(NAVIGATION_ELEMENT_IS_NOT_TARGET) == null) {
            return target.getNavigationElement();
        }
        return target;
    }
}

