/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignatureVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrImmediateClosureParameterImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrImmediateClosureSignatureImpl
implements GrClosureSignature {
    private static final Logger LOG = Logger.getInstance(GrImmediateClosureSignatureImpl.class);
    private final boolean myIsVarargs;
    private final boolean myCurried;
    private final PsiType myReturnType;
    private final GrClosureParameter[] myParameters;
    private final PsiSubstitutor mySubstitutor;

    public GrImmediateClosureSignatureImpl(PsiParameter[] parameters, PsiType returnType, PsiSubstitutor substitutor) {
        LOG.assertTrue(returnType == null || returnType.isValid());
        LOG.assertTrue(substitutor.isValid());
        this.myReturnType = substitutor.substitute(returnType);
        int length = parameters.length;
        this.myParameters = new GrClosureParameter[length];
        for (int i = 0; i < length; ++i) {
            this.myParameters[i] = new GrImmediateClosureParameterImpl(parameters[i], substitutor);
        }
        this.myIsVarargs = GrClosureSignatureUtil.isVarArgsImpl(this.myParameters);
        this.mySubstitutor = substitutor;
        this.myCurried = false;
    }

    public GrImmediateClosureSignatureImpl(PsiParameter[] parameters, PsiType returnType) {
        this(parameters, returnType, PsiSubstitutor.EMPTY);
    }

    public GrImmediateClosureSignatureImpl(GrClosureParameter[] params, PsiType returnType, boolean isVarArgs, boolean isCurried) {
        this.myParameters = params;
        this.myReturnType = returnType;
        this.myIsVarargs = isVarArgs;
        this.myCurried = isCurried;
        this.mySubstitutor = PsiSubstitutor.EMPTY;
    }

    @Override
    public boolean isVarargs() {
        return this.myIsVarargs;
    }

    @Override
    public PsiType getReturnType() {
        return this.myReturnType;
    }

    @Override
    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    @Override
    public GrClosureParameter[] getParameters() {
        GrClosureParameter[] result = new GrClosureParameter[this.myParameters.length];
        System.arraycopy(this.myParameters, 0, result, 0, this.myParameters.length);
        return result;
    }

    @Override
    public int getParameterCount() {
        return this.myParameters.length;
    }

    @Override
    public GrSignature curry(PsiType[] args, int position, PsiElement context) {
        return GrClosureSignatureUtil.curryImpl(this, args, position, context);
    }

    @Override
    public boolean isValid() {
        for (GrClosureParameter parameter : this.myParameters) {
            if (parameter.isValid()) continue;
            return false;
        }
        PsiType returnType = this.getReturnType();
        return returnType == null || returnType.isValid();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrClosureSignature) {
            return Comparing.equal((Object[])this.myParameters, (Object[])((GrClosureSignature)obj).getParameters()) && Comparing.equal((Object)this.myIsVarargs, (Object)((GrClosureSignature)obj).isVarargs());
        }
        return super.equals(obj);
    }

    @Override
    public boolean isCurried() {
        return this.myCurried;
    }

    public static GrClosureSignature getLeastUpperBound(GrClosureSignature signature1, GrClosureSignature signature2, PsiManager manager) {
        GrClosureParameter[] parameters2;
        GrClosureParameter[] parameters1 = signature1.getParameters();
        if (parameters1.length == (parameters2 = signature2.getParameters()).length) {
            GrClosureParameter[] params = new GrClosureParameter[parameters1.length];
            for (int i = 0; i < params.length; ++i) {
                PsiType type = GenericsUtil.getGreatestLowerBound((PsiType)parameters1[i].getType(), (PsiType)parameters2[i].getType());
                boolean opt = parameters1[i].isOptional() && parameters2[i].isOptional();
                String name = StringUtil.equals((CharSequence)parameters1[i].getName(), (CharSequence)parameters2[i].getName()) ? parameters1[i].getName() : null;
                params[i] = new GrImmediateClosureParameterImpl(type, name, opt, null);
            }
            PsiType s1type = signature1.getReturnType();
            PsiType s2type = signature2.getReturnType();
            PsiType returnType = null;
            if (s1type != null && s2type != null) {
                returnType = TypesUtil.getLeastUpperBound(s1type, s2type, manager);
            }
            boolean isVarArgs = signature1.isVarargs() && signature2.isVarargs();
            return new GrImmediateClosureSignatureImpl(params, returnType, isVarArgs, false);
        }
        return null;
    }

    @Override
    public void accept(GrSignatureVisitor visitor) {
        visitor.visitClosureSignature(this);
    }
}

