/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrNamedArgumentSearchVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrAccessorMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrFieldImpl
extends GrVariableBaseImpl<GrFieldStub>
implements GrField,
StubBasedPsiElement<GrFieldStub> {
    public GrFieldImpl(ASTNode node) {
        super(node);
    }

    public GrFieldImpl(GrFieldStub stub) {
        this(stub, GroovyElementTypes.FIELD);
    }

    public GrFieldImpl(GrFieldStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByStub();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitField(this);
    }

    @Override
    public GrTypeElement getTypeElementGroovy() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            String typeText = stub.getTypeText();
            if (typeText == null) {
                return null;
            }
            return GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(typeText, this);
        }
        return super.getTypeElementGroovy();
    }

    public String toString() {
        return "Field";
    }

    @Override
    public PsiExpression getInitializer() {
        return PsiImplUtil.getOrCreatePisExpression(this.getInitializerGroovy());
    }

    public void setInitializer(PsiExpression psiExpression) throws IncorrectOperationException {
        GrExpression oldInitializer = this.getInitializerGroovy();
        if (psiExpression == null) {
            if (oldInitializer != null) {
                oldInitializer.delete();
                PsiElement assign = this.findChildByType(GroovyTokenTypes.mASSIGN);
                if (assign != null) {
                    assign.delete();
                }
            }
            return;
        }
        GrExpression newInitializer = GroovyPsiElementFactory.getInstance(this.getProject()).createExpressionFromText(psiExpression.getText());
        if (oldInitializer != null) {
            oldInitializer.replaceWithExpression(newInitializer, true);
        } else {
            this.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", this.getNode().getLastChildNode());
            this.addAfter(newInitializer, this.getLastChild());
        }
    }

    @Override
    public boolean isDeprecated() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecatedByDocTag() || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    @Override
    public PsiType getTypeGroovy() {
        PsiType type = TypeInferenceHelper.getCurrentContext().getExpressionType(this, new Function<GrFieldImpl, PsiType>(){

            public PsiType fun(GrFieldImpl field) {
                PsiType type;
                if (GrFieldImpl.this.getDeclaredType() == null && GrFieldImpl.this.getInitializerGroovy() == null && (type = GrVariableEnhancer.getEnhancedType(field)) != null) {
                    return type;
                }
                return null;
            }
        });
        if (type != null) {
            return type;
        }
        return super.getTypeGroovy();
    }

    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent = this.getParent().getParent();
        if (parent instanceof GrTypeDefinitionBody && (pparent = parent.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFileBase) {
            return ((GroovyFileBase)file).getScriptClass();
        }
        return null;
    }

    @Override
    public boolean isProperty() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            return stub.isProperty();
        }
        return PsiUtil.isProperty(this);
    }

    @Override
    public GrAccessorMethod getSetter() {
        return (GrAccessorMethod)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<GrAccessorMethod>(){

            public CachedValueProvider.Result<GrAccessorMethod> compute() {
                return CachedValueProvider.Result.create((Object)GrAccessorMethodImpl.createSetterMethod(GrFieldImpl.this), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    @Override
    public GrAccessorMethod[] getGetters() {
        return (GrAccessorMethod[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<GrAccessorMethod[]>(){

            public CachedValueProvider.Result<GrAccessorMethod[]> compute() {
                return CachedValueProvider.Result.create((Object)GrAccessorMethodImpl.createGetterMethods(GrFieldImpl.this), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    @Override
    public SearchScope getUseScope() {
        if (this.isProperty()) {
            return ResolveScopeManager.getElementUseScope((PsiElement)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.getMemberUseScope((PsiMember)this);
    }

    @Override
    public String getName() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return super.getName();
    }

    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getFieldPresentation((PsiField)this);
    }

    public PsiElement getOriginalElement() {
        PsiClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return this;
        }
        PsiClass originalClass = (PsiClass)containingClass.getOriginalElement();
        PsiField originalField = originalClass.findFieldByName(this.getName(), false);
        return originalField != null ? originalField : this;
    }

    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon superIcon = JetgroovyIcons.Groovy.Field;
        if (!this.isProperty()) {
            return superIcon;
        }
        LayeredIcon rowIcon = new LayeredIcon(2);
        rowIcon.setIcon(superIcon, 0);
        rowIcon.setIcon(JetgroovyIcons.Groovy.Def, 1);
        return rowIcon;
    }

    @Override
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            String[] namedParameters = stub.getNamedParameters();
            if (namedParameters.length == 0) {
                return Collections.emptyMap();
            }
            HashMap result = ContainerUtil.newHashMap();
            for (String parameter : namedParameters) {
                result.put(parameter, GrNamedArgumentSearchVisitor.CODE_NAMED_ARGUMENTS_DESCR);
            }
            return result;
        }
        return GrNamedArgumentSearchVisitor.find(this);
    }

    @Override
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }
}

