/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrVariableBaseImpl<T extends StubElement>
extends GrStubElementBase<T>
implements GrVariable {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableImpl");
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"grVariableInitializer");

    public GrVariableBaseImpl(ASTNode node) {
        super(node);
    }

    protected GrVariableBaseImpl(T stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByTree();
    }

    public PsiTypeElement getTypeElement() {
        return PsiImplUtil.getOrCreateTypeElement(this.getTypeElementGroovy());
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        PsiElement prev = PsiUtil.getPrevNonSpace(this);
        PsiElement next = PsiUtil.getNextNonSpace(this);
        ASTNode parentNode = parent.getNode();
        assert (parentNode != null);
        super.delete();
        if (prev != null && prev.getNode() != null && prev.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
            prev.delete();
        } else if (next instanceof LeafPsiElement && next.getNode() != null && next.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
            next.delete();
        }
        if (parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).getVariables().length == 0) {
            parent.delete();
        }
    }

    public boolean hasModifierProperty(@NonNls String property) {
        GrModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(property);
    }

    public PsiType getType() {
        PsiType type = this.getDeclaredType();
        return type != null ? type : TypesUtil.getJavaLangObject(this);
    }

    @Override
    public GrTypeElement getTypeElementGroovy() {
        PsiElement parent = this.getParent();
        if (parent instanceof GrVariableDeclaration) {
            return ((GrVariableDeclaration)parent).getTypeElementGroovyForVariable(this);
        }
        return null;
    }

    @Override
    public PsiType getDeclaredType() {
        GrTypeElement typeElement = this.getTypeElementGroovy();
        if (typeElement != null) {
            return typeElement.getType();
        }
        return null;
    }

    @Override
    public PsiType getTypeGroovy() {
        final GrExpression initializer = this.getInitializerGroovy();
        GrTypeElement typeElement = this.getTypeElementGroovy();
        PsiType declaredType = null;
        if (typeElement != null && !((declaredType = typeElement.getType()) instanceof PsiClassType)) {
            return declaredType;
        }
        if (initializer != null) {
            PsiClassType.ClassResolveResult initializerResult;
            PsiClass initializerClass;
            PsiType initializerType = (PsiType)ourGuard.doPreventingRecursion((Object)this, true, (Computable)new NullableComputable<PsiType>(){

                public PsiType compute() {
                    return initializer.getType();
                }
            });
            if (declaredType == null) {
                return initializerType;
            }
            if (initializerType instanceof PsiClassType && TypesUtil.isAssignable(declaredType, initializerType, this) && (initializerClass = (initializerResult = ((PsiClassType)initializerType).resolveGenerics()).getElement()) != null && !com.intellij.psi.util.PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)initializerClass, (PsiSubstitutor)initializerResult.getSubstitutor())) {
                return initializerType;
            }
        }
        return declaredType;
    }

    @Override
    public void setType(PsiType type) {
        GrTypeElement newTypeElement;
        GrVariableDeclaration variableDeclaration = this.getDeclaration();
        if (variableDeclaration == null) {
            return;
        }
        GrTypeElement typeElement = variableDeclaration.getTypeElementGroovyForVariable(this);
        if (type == null) {
            if (typeElement != null) {
                if (!variableDeclaration.isTuple() && variableDeclaration.getModifierList().getModifiers().length == 0) {
                    variableDeclaration.getModifierList().setModifierProperty("def", true);
                }
                typeElement.delete();
            }
            return;
        }
        type = TypesUtil.unboxPrimitiveTypeWrapper(type);
        try {
            newTypeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(type);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        newTypeElement = typeElement == null ? (GrTypeElement)this.getParent().addBefore((PsiElement)newTypeElement, (PsiElement)this) : (GrTypeElement)typeElement.replace(newTypeElement);
        JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences((PsiElement)newTypeElement);
    }

    @Override
    public PsiElement getNameIdentifierGroovy() {
        PsiElement ident = this.findChildByType(TokenSets.PROPERTY_NAMES);
        assert (ident != null) : this.getText();
        return ident;
    }

    @Override
    public GrExpression getInitializerGroovy() {
        GrVariableDeclaration tuple;
        GrExpression initializer;
        PsiElement parent = this.getParent();
        if (parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).isTuple() && (initializer = (tuple = (GrVariableDeclaration)parent).getTupleInitializer()) instanceof GrListOrMap) {
            int varNumber;
            GrListOrMap listOrMap = (GrListOrMap)initializer;
            GrExpression[] initializers = listOrMap.getInitializers();
            if (initializers.length < (varNumber = ArrayUtil.indexOf((Object[])tuple.getVariables(), (Object)this)) + 1) {
                return null;
            }
            return initializers[varNumber];
        }
        return GroovyPsiElementImpl.findExpressionChild(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    public PsiElement setName(@NonNls String name) throws IncorrectOperationException {
        PsiImplUtil.setName(name, this.getNameIdentifierGroovy());
        return this;
    }

    public SearchScope getUseScope() {
        GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)this, GrVariableDeclarationOwner.class);
        if (owner != null) {
            return new LocalSearchScope((PsiElement)owner);
        }
        return super.getUseScope();
    }

    @Override
    public String getName() {
        return PsiImplUtil.getName(this);
    }

    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this);
    }

    @Override
    public GrModifierList getModifierList() {
        GrVariableDeclaration variableDeclaration = this.getDeclaration();
        if (variableDeclaration != null) {
            return variableDeclaration.getModifierList();
        }
        return null;
    }

    public Icon getIcon(int flags) {
        return JetgroovyIcons.Groovy.Variable;
    }

    private GrVariableDeclaration getDeclaration() {
        PsiElement parent = this.getParent();
        if (parent instanceof GrVariableDeclaration) {
            return (GrVariableDeclaration)parent;
        }
        return null;
    }

    public void deleteChildInternal(ASTNode child) {
        PsiElement psi = child.getPsi();
        if (psi == this.getInitializerGroovy()) {
            this.deleteChildInternal(this.findNotNullChildByType(GroovyTokenTypes.mASSIGN).getNode());
        }
        super.deleteChildInternal(child);
    }

    @Override
    public void setInitializerGroovy(GrExpression initializer) {
        if (this.getParent() instanceof GrVariableDeclaration && ((GrVariableDeclaration)this.getParent()).isTuple()) {
            throw new UnsupportedOperationException("don't invoke 'setInitializer()' for tuple declaration");
        }
        GrExpression oldInitializer = this.getInitializerGroovy();
        if (initializer == null) {
            if (oldInitializer != null) {
                oldInitializer.delete();
                PsiElement assign = this.findChildByType(GroovyTokenTypes.mASSIGN);
                if (assign != null) {
                    assign.delete();
                }
            }
            return;
        }
        if (oldInitializer != null) {
            oldInitializer.replaceWithExpression(initializer, true);
        } else {
            this.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", null);
            this.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", null);
            this.addAfter(initializer, this.getLastChild());
        }
    }
}

