/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks.GrBlockImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks.GrDelegatesToUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.params.GrParameterListImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.ClosureSyntheticParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class GrClosableBlockImpl
extends GrBlockImpl
implements GrClosableBlock {
    private volatile GrParameter[] mySyntheticItParameter;
    private static final Function<GrClosableBlock, PsiType> ourTypesCalculator = new NullableFunction<GrClosableBlock, PsiType>(){

        public PsiType fun(GrClosableBlock block) {
            return GroovyPsiManager.inferType(block, new MethodTypeInferencer(block));
        }
    };

    public GrClosableBlockImpl(IElementType type, CharSequence buffer) {
        super(type, buffer);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitClosure(this);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.mySyntheticItParameter = null;
    }

    @Override
    public boolean processClosureDeclarations(PsiScopeProcessor plainProcessor, PsiScopeProcessor nonCodeProcessor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!this.processDeclarations(plainProcessor, state, lastParent, place)) {
            return false;
        }
        return this.processOwnerAndDelegate(plainProcessor, nonCodeProcessor, state, place);
    }

    @Override
    public boolean processDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (lastParent == null) {
            return true;
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (!this.processParameters(processor, state, place)) {
            return false;
        }
        if (ResolveUtil.shouldProcessProperties((ClassHint)processor.getHint(ClassHint.KEY)) && !ResolveUtil.processElement(processor, (PsiNamedElement)this.getOwner(), state)) {
            return false;
        }
        return this.processClosureClassMembers(processor, state, lastParent, place);
    }

    private boolean processOwnerAndDelegate(PsiScopeProcessor processor, PsiScopeProcessor nonCodeProcessor, ResolveState state, PsiElement place) {
        Boolean result = this.processDelegatesTo(processor, nonCodeProcessor, state, place);
        if (result != null) {
            return result;
        }
        return this.processOwner(processor, nonCodeProcessor, state, place);
    }

    private Boolean processDelegatesTo(PsiScopeProcessor processor, PsiScopeProcessor nonCodeProcessor, ResolveState state, PsiElement place) {
        GrDelegatesToUtil.DelegatesToInfo info = GrDelegatesToUtil.getDelegatesToInfo(place, this);
        if (info == null) {
            return null;
        }
        switch (info.getStrategy()) {
            case 0: {
                if (!this.processOwner(processor, nonCodeProcessor, state, place)) {
                    return false;
                }
                if (!this.processDelegate(processor, nonCodeProcessor, state, place, info.getTypeToDelegate())) {
                    return false;
                }
                return true;
            }
            case 1: {
                if (!this.processDelegate(processor, nonCodeProcessor, state, place, info.getTypeToDelegate())) {
                    return false;
                }
                if (!this.processOwner(processor, nonCodeProcessor, state, place)) {
                    return false;
                }
                return true;
            }
            case 2: {
                if (!this.processOwner(processor, nonCodeProcessor, state, place)) {
                    return false;
                }
                return true;
            }
            case 3: {
                if (!this.processDelegate(processor, nonCodeProcessor, state, place, info.getTypeToDelegate())) {
                    return false;
                }
                return true;
            }
            case 4: {
                return true;
            }
        }
        return null;
    }

    private boolean processDelegate(PsiScopeProcessor processor, PsiScopeProcessor nonCodeProcessor, ResolveState state, PsiElement place, PsiType classToDelegate) {
        if (classToDelegate == null) {
            return true;
        }
        return ResolveUtil.processAllDeclarationsSeparately(classToDelegate, processor, nonCodeProcessor, state.put(ClassHint.RESOLVE_CONTEXT, (Object)this), place);
    }

    private boolean processClosureClassMembers(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiClass closureClass = GroovyPsiManager.getInstance(this.getProject()).findClassWithCache("groovy.lang.Closure", this.getResolveScope());
        if (closureClass == null) {
            return true;
        }
        return closureClass.processDeclarations(processor, state.put(ClassHint.RESOLVE_CONTEXT, (Object)this), lastParent, place);
    }

    private boolean processParameters(PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        GrParameter[] synth;
        if (!ResolveUtil.shouldProcessProperties((ClassHint)processor.getHint(ClassHint.KEY))) {
            return true;
        }
        if (this.hasParametersSection()) {
            for (GrParameter parameter : this.getParameters()) {
                if (ResolveUtil.processElement(processor, parameter, state)) continue;
                return false;
            }
        } else if (!this.isItAlreadyDeclared(place) && (synth = this.getSyntheticItParameter()).length > 0 && !ResolveUtil.processElement(processor, synth[0], state.put(ClassHint.RESOLVE_CONTEXT, (Object)this))) {
            return false;
        }
        return true;
    }

    private boolean processOwner(PsiScopeProcessor processor, PsiScopeProcessor nonCodeProcessor, ResolveState state, PsiElement place) {
        PsiElement parent = this.getParent();
        if (parent == null) {
            return true;
        }
        if (!ResolveUtil.processStaticImports(processor, this.getContainingFile(), state, place)) {
            return false;
        }
        return ResolveUtil.doTreeWalkUp(parent, place, processor, nonCodeProcessor, state);
    }

    private boolean isItAlreadyDeclared(PsiElement place) {
        while (place != this && place != null) {
            if (place instanceof GrClosableBlock && !((GrClosableBlock)place).hasParametersSection() && !(place.getParent() instanceof GrStringInjection)) {
                return true;
            }
            place = place.getParent();
        }
        return false;
    }

    public String toString() {
        return "Closable block";
    }

    @Override
    public GrParameter[] getParameters() {
        if (this.hasParametersSection()) {
            GrParameterListImpl parameterList = this.getParameterList();
            return parameterList.getParameters();
        }
        return GrParameter.EMPTY_ARRAY;
    }

    @Override
    public GrParameter[] getAllParameters() {
        if (this.getParent() instanceof GrStringInjection) {
            return GrParameter.EMPTY_ARRAY;
        }
        if (this.hasParametersSection()) {
            return this.getParameters();
        }
        return this.getSyntheticItParameter();
    }

    @Override
    public PsiElement getArrow() {
        return this.findPsiChildByType(GroovyTokenTypes.mCLOSABLE_BLOCK_OP);
    }

    @Override
    public boolean isVarArgs() {
        return PsiImplUtil.isVarArgs(this.getParameters());
    }

    @Override
    public GrParameterListImpl getParameterList() {
        GrParameterListImpl childByClass = (GrParameterListImpl)this.findChildByClass(GrParameterListImpl.class);
        assert (childByClass != null);
        return childByClass;
    }

    @Override
    public GrParameter addParameter(GrParameter parameter) {
        GrParameterListImpl parameterList = this.getParameterList();
        if (this.getArrow() == null) {
            GrParameterList newParamList = (GrParameterList)this.addAfter(parameterList, this.getLBrace());
            parameterList.delete();
            ASTNode next = newParamList.getNode().getTreeNext();
            this.getNode().addLeaf(GroovyTokenTypes.mCLOSABLE_BLOCK_OP, (CharSequence)"->", next);
            return (GrParameter)newParamList.add(parameter);
        }
        return (GrParameter)parameterList.add(parameter);
    }

    @Override
    public boolean hasParametersSection() {
        return this.getArrow() != null;
    }

    @Override
    public PsiType getType() {
        return GrClosureType.create(this, true);
    }

    @Override
    public PsiType getNominalType() {
        return this.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrParameter[] getSyntheticItParameter() {
        if (this.getParent() instanceof GrStringInjection) {
            return GrParameter.EMPTY_ARRAY;
        }
        GrParameter[] res = this.mySyntheticItParameter;
        if (res == null) {
            res = new GrParameter[]{new ClosureSyntheticParameter(this)};
            GrClosableBlockImpl grClosableBlockImpl = this;
            synchronized (grClosableBlockImpl) {
                if (this.mySyntheticItParameter == null) {
                    this.mySyntheticItParameter = res;
                }
            }
        }
        return res;
    }

    private PsiVariable getOwner() {
        return (PsiVariable)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiVariable>(){

            public CachedValueProvider.Result<PsiVariable> compute() {
                PsiClass scriptClass;
                GroovyPsiElement context = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)GrClosableBlockImpl.this, (Class[])new Class[]{GrTypeDefinition.class, GrClosableBlock.class, GroovyFile.class});
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)GrClosableBlockImpl.this.getProject()).getElementFactory();
                PsiClassType type = null;
                if (context instanceof GrTypeDefinition) {
                    type = factory.createType((PsiClass)context);
                } else if (context instanceof GrClosableBlock) {
                    type = GrClosureType.create((GrClosableBlock)context, true);
                } else if (context instanceof GroovyFile && (scriptClass = ((GroovyFile)context).getScriptClass()) != null && GroovyNamesUtil.isIdentifier(scriptClass.getName())) {
                    type = factory.createType(scriptClass);
                }
                if (type == null) {
                    type = TypesUtil.getJavaLangObject(GrClosableBlockImpl.this);
                }
                GrLightVariable owner = new GrLightVariable((PsiManager)GrClosableBlockImpl.this.getManager(), "owner", (PsiType)type, (PsiElement)GrClosableBlockImpl.this);
                return CachedValueProvider.Result.create((Object)owner, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    @Override
    public GrExpression replaceWithExpression(GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    @Override
    public PsiType getReturnType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, ourTypesCalculator);
    }

    @Override
    public void removeStatement() throws IncorrectOperationException {
        GroovyPsiElementImpl.removeStatement(this);
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return !(this.getParent() instanceof GrStringInjection);
    }
}

