/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryExpressionTypeCalculators;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryExpressionUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryFacade;

public class GrAssignmentExpressionImpl
extends GrExpressionImpl
implements GrAssignmentExpression {
    private final GrBinaryFacade myFacade = new GrBinaryFacade(){

        @Override
        public GrExpression getLeftOperand() {
            return GrAssignmentExpressionImpl.this.getLValue();
        }

        @Override
        public GrExpression getRightOperand() {
            return GrAssignmentExpressionImpl.this.getRValue();
        }

        @Override
        public IElementType getOperationTokenType() {
            return GrAssignmentExpressionImpl.this.getOperationTokenType();
        }

        @Override
        public PsiElement getOperationToken() {
            return GrAssignmentExpressionImpl.this.getOperationToken();
        }

        @Override
        public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
            return GrAssignmentExpressionImpl.this.multiResolve(false);
        }

        @Override
        public GrExpression getPsiElement() {
            return GrAssignmentExpressionImpl.this;
        }
    };
    private static final ResolveCache.PolyVariantResolver<GrAssignmentExpressionImpl> RESOLVER = new ResolveCache.PolyVariantResolver<GrAssignmentExpressionImpl>(){

        public GroovyResolveResult[] resolve(GrAssignmentExpressionImpl assignmentExpression, boolean incompleteCode) {
            IElementType opType = assignmentExpression.getOperationTokenType();
            if (opType == GroovyTokenTypes.mASSIGN) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            GrExpression lValue = assignmentExpression.getLValue();
            PsiType lType = lValue instanceof GrIndexProperty ? ((GrIndexProperty)lValue).getGetterType() : lValue.getType();
            if (lType == null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            PsiType rType = GrBinaryExpressionUtil.getRightType(assignmentExpression.getFacade());
            IElementType operatorToken = TokenSets.ASSIGNMENTS_TO_OPERATORS.get(opType);
            return TypesUtil.getOverloadedOperatorCandidates(lType, operatorToken, lValue, new PsiType[]{rType});
        }
    };
    private static final Function<GrAssignmentExpressionImpl, PsiType> TYPE_CALCULATOR = new Function<GrAssignmentExpressionImpl, PsiType>(){

        public PsiType fun(GrAssignmentExpressionImpl expression) {
            Function<GrBinaryFacade, PsiType> calculator = GrBinaryExpressionTypeCalculators.getTypeCalculator(expression.getFacade());
            return (PsiType)calculator.fun((Object)expression.getFacade());
        }
    };

    private GrBinaryFacade getFacade() {
        return this.myFacade;
    }

    public GrAssignmentExpressionImpl(ASTNode node) {
        super(node);
    }

    public String toString() {
        return "Assignment expression";
    }

    @Override
    public GrExpression getLValue() {
        return GrAssignmentExpressionImpl.findExpressionChild(this);
    }

    @Override
    public GrExpression getRValue() {
        GrExpression[] exprs = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (exprs.length > 1) {
            return exprs[1];
        }
        return null;
    }

    @Override
    public IElementType getOperationTokenType() {
        return this.getOperationToken().getNode().getElementType();
    }

    @Override
    public PsiElement getOperationToken() {
        return this.findNotNullChildByType(TokenSets.ASSIGN_OP_SET);
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPE_CALCULATOR);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAssignmentExpression(this);
    }

    @Override
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        return TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, RESOLVER);
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement token = this.getOperationToken();
        int offset = token.getStartOffsetInParent();
        return new TextRange(offset, offset + token.getTextLength());
    }

    public PsiElement resolve() {
        return PsiImplUtil.extractUniqueElement(this.multiResolve(false));
    }

    public String getCanonicalText() {
        return this.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException("assignment expression cannot be renamed");
    }

    public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException("assignment expression cannot be bound to anything");
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiReference getReference() {
        IElementType operationToken = this.getOperationTokenType();
        if (operationToken == GroovyTokenTypes.mASSIGN) {
            return null;
        }
        return this;
    }
}

