/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;

public class GrAnonymousClassDefinitionImpl
extends GrTypeDefinitionImpl
implements GrAnonymousClassDefinition {
    private SoftReference<PsiClassType> myCachedBaseType = null;

    public GrAnonymousClassDefinitionImpl(ASTNode node) {
        super(node);
    }

    public GrAnonymousClassDefinitionImpl(GrTypeDefinitionStub stub) {
        this(stub, GroovyElementTypes.ANONYMOUS_CLASS_DEFINITION);
    }

    public GrAnonymousClassDefinitionImpl(GrTypeDefinitionStub stub, GrStubElementType nodeType) {
        super(stub, (IStubElementType)nodeType);
    }

    @Override
    public GrCodeReferenceElement getBaseClassReferenceGroovy() {
        return (GrCodeReferenceElement)this.findNotNullChildByClass(GrCodeReferenceElement.class);
    }

    @Override
    public boolean hasModifierProperty(@NonNls String name) {
        return "final".equals(name);
    }

    @Override
    public GrArgumentList getArgumentListGroovy() {
        return (GrArgumentList)this.findChildByClass(GrArgumentList.class);
    }

    public boolean isInQualifiedNew() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.isAnonymousInQualifiedNew();
        }
        PsiElement parent = this.getParent();
        return parent instanceof GrNewExpression && ((GrNewExpression)parent).getQualifier() != null;
    }

    public PsiJavaCodeReferenceElement getBaseClassReference() {
        GrCodeReferenceElement ref = this.getBaseClassReferenceGroovy();
        PsiElement element = ref.resolve();
        Project project = this.getProject();
        if (element instanceof PsiClass) {
            GrClassReferenceType type = new GrClassReferenceType(ref);
            return JavaPsiFacade.getElementFactory((Project)project).createReferenceElementByType((PsiClassType)type);
        }
        String qName = ref.getReferenceName();
        assert (qName != null);
        return JavaPsiFacade.getElementFactory((Project)project).createReferenceElementByFQClassName(qName, GlobalSearchScope.allScope((Project)project));
    }

    public PsiClassType getBaseClassType() {
        if (this.isInQualifiedNew()) {
            return this.createClassType();
        }
        PsiClassType type = (PsiClassType)SoftReference.dereference(this.myCachedBaseType);
        if (type != null && type.isValid()) {
            return type;
        }
        type = this.createClassType();
        this.myCachedBaseType = new SoftReference((Object)type);
        return type;
    }

    public PsiExpressionList getArgumentList() {
        return null;
    }

    private PsiClassType createClassType() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(this.getBaseClassReference());
    }

    private PsiClass getBaseClass() {
        PsiElement element = this.getBaseClassReferenceGroovy().resolve();
        if (element instanceof PsiClass) {
            return (PsiClass)element;
        }
        return null;
    }

    @Override
    public PsiElement getNameIdentifierGroovy() {
        return this.getBaseClassReferenceGroovy().getReferenceNameElement();
    }

    @Override
    public boolean processDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (lastParent instanceof GrArgumentList) {
            return true;
        }
        GrCodeReferenceElement refElement = this.getBaseClassReferenceGroovy();
        if (refElement == place || refElement == lastParent) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public PsiClass getSuperClass() {
        PsiClass psiClass = this.getBaseClass();
        if (psiClass != null && !psiClass.isInterface()) {
            return psiClass;
        }
        return GroovyPsiManager.getInstance(this.getProject()).findClassWithCache("groovy.lang.GroovyObjectSupport", this.getResolveScope());
    }

    private PsiClassType createTypeByName(String className) {
        return TypesUtil.createTypeByFQClassName(className, this);
    }

    @Override
    public String[] getSuperClassNames() {
        return new String[]{this.getBaseClassReferenceGroovy().getReferenceName()};
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    public PsiClassType[] getExtendsListTypes() {
        PsiClass baseClass = this.getBaseClass();
        if (baseClass != null) {
            if (baseClass.isInterface()) {
                return new PsiClassType[]{this.createTypeByName("groovy.lang.GroovyObjectSupport")};
            }
            if (baseClass instanceof GrTypeDefinition) {
                return new PsiClassType[]{this.getBaseClassType()};
            }
            return new PsiClassType[]{this.getBaseClassType(), this.createTypeByName("groovy.lang.GroovyObjectSupport")};
        }
        return super.getExtendsListTypes();
    }

    @Override
    public GrExtendsClause getExtendsClause() {
        return null;
    }

    @Override
    public GrImplementsClause getImplementsClause() {
        return null;
    }

    @Override
    public PsiClassType[] getImplementsListTypes() {
        PsiClass baseClass = this.getBaseClass();
        if (baseClass != null && baseClass.isInterface()) {
            return new PsiClassType[]{this.getBaseClassType(), this.createTypeByName("groovy.lang.GroovyObject")};
        }
        return new PsiClassType[]{this.createTypeByName("groovy.lang.GroovyObject")};
    }

    public String toString() {
        return "Anonymous class";
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    protected Object clone() {
        Object o = super.clone();
        ((GrAnonymousClassDefinitionImpl)o).myCachedBaseType = null;
        return o;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAnonymousClassDefinition(this);
    }
}

