/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityIcons;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleSettingsFacade;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionMembersCache;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyRunnerPsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrTypeDefinitionImpl
extends GrStubElementBase<GrTypeDefinitionStub>
implements GrTypeDefinition,
StubBasedPsiElement<GrTypeDefinitionStub> {
    private final GrTypeDefinitionMembersCache myCache = new GrTypeDefinitionMembersCache(this);

    public GrTypeDefinitionImpl(ASTNode node) {
        super(node);
    }

    protected GrTypeDefinitionImpl(GrTypeDefinitionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public PsiElement getParent() {
        return this.getDefinitionParent();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitTypeDefinition(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    @Override
    public String getQualifiedName() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GroovyFile) {
            String packageName = ((GroovyFile)parent).getPackageName();
            return !packageName.isEmpty() ? packageName + "." + this.getName() : this.getName();
        }
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && containingClass.getQualifiedName() != null) {
            return containingClass.getQualifiedName() + "." + this.getName();
        }
        return null;
    }

    @Override
    public GrTypeDefinitionBody getBody() {
        return (GrTypeDefinitionBody)this.getStubOrPsiChild((IStubElementType)GroovyElementTypes.CLASS_BODY);
    }

    @Override
    public GrMembersDeclaration[] getMemberDeclarations() {
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            return GrMembersDeclaration.EMPTY_ARRAY;
        }
        return body.getMemberDeclarations();
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    public GrExtendsClause getExtendsClause() {
        return (GrExtendsClause)this.getStubOrPsiChild(GroovyElementTypes.EXTENDS_CLAUSE);
    }

    @Override
    public GrImplementsClause getImplementsClause() {
        return (GrImplementsClause)this.getStubOrPsiChild(GroovyElementTypes.IMPLEMENTS_CLAUSE);
    }

    @Override
    public String[] getSuperClassNames() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getSuperClassNames();
        }
        return ArrayUtil.mergeArrays((String[])this.getExtendsNames(), (String[])this.getImplementsNames());
    }

    protected String[] getImplementsNames() {
        GrImplementsClause implementsClause = this.getImplementsClause();
        GrCodeReferenceElement[] implementsRefs = implementsClause != null ? implementsClause.getReferenceElementsGroovy() : GrCodeReferenceElement.EMPTY_ARRAY;
        ArrayList<String> implementsNames = new ArrayList<String>(implementsRefs.length);
        for (GrCodeReferenceElement ref : implementsRefs) {
            String name = ref.getReferenceName();
            if (name == null) continue;
            implementsNames.add(name);
        }
        return ArrayUtil.toStringArray(implementsNames);
    }

    protected String[] getExtendsNames() {
        GrExtendsClause extendsClause = this.getExtendsClause();
        GrCodeReferenceElement[] extendsRefs = extendsClause != null ? extendsClause.getReferenceElementsGroovy() : GrCodeReferenceElement.EMPTY_ARRAY;
        ArrayList<String> extendsNames = new ArrayList<String>(extendsRefs.length);
        for (GrCodeReferenceElement ref : extendsRefs) {
            String name = ref.getReferenceName();
            if (name == null) continue;
            extendsNames.add(name);
        }
        return ArrayUtil.toStringArray(extendsNames);
    }

    @Override
    public PsiElement getNameIdentifierGroovy() {
        PsiElement result = this.findChildByType(TokenSets.PROPERTY_NAMES);
        assert (result != null);
        return result;
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        GroovyFileImpl file;
        PsiElement parent = this.getParent();
        if (parent instanceof GroovyFileImpl && (file = (GroovyFileImpl)parent).getTypeDefinitions().length == 1 && !file.isScript()) {
            file.delete();
            return;
        }
        super.delete();
    }

    public boolean processDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return GrClassImplUtil.processDeclarations(this, processor, state, lastParent, place);
    }

    @Override
    public String getName() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return PsiImplUtil.getName(this);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return GrClassImplUtil.isClassEquivalentTo(this, another);
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isTrait() {
        return false;
    }

    public PsiReferenceList getExtendsList() {
        return this.getExtendsClause();
    }

    public PsiReferenceList getImplementsList() {
        return this.getImplementsClause();
    }

    public PsiClassType[] getExtendsListTypes() {
        return (PsiClassType[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiClassType[]>(){

            public CachedValueProvider.Result<PsiClassType[]> compute() {
                return CachedValueProvider.Result.create((Object)GrClassImplUtil.getExtendsListTypes(GrTypeDefinitionImpl.this), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }

    public PsiClassType[] getImplementsListTypes() {
        return (PsiClassType[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiClassType[]>(){

            public CachedValueProvider.Result<PsiClassType[]> compute() {
                return CachedValueProvider.Result.create((Object)GrClassImplUtil.getImplementsListTypes(GrTypeDefinitionImpl.this), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }

    public PsiClass getSuperClass() {
        return GrClassImplUtil.getSuperClass(this);
    }

    public PsiClass[] getInterfaces() {
        return (PsiClass[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiClass[]>(){

            public CachedValueProvider.Result<PsiClass[]> compute() {
                return CachedValueProvider.Result.create((Object)GrClassImplUtil.getInterfaces(GrTypeDefinitionImpl.this), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }

    public final PsiClass[] getSupers() {
        return GrClassImplUtil.getSupers(this);
    }

    public PsiClassType[] getSuperTypes() {
        return GrClassImplUtil.getSuperTypes(this);
    }

    @Override
    public GrField[] getCodeFields() {
        GrTypeDefinitionBody body = this.getBody();
        if (body != null) {
            return body.getFields();
        }
        return GrField.EMPTY_ARRAY;
    }

    @Override
    public PsiField findCodeFieldByName(String name, boolean checkBases) {
        return GrClassImplUtil.findFieldByName(this, name, checkBases, false);
    }

    @Override
    public GrField[] getFields() {
        return this.myCache.getFields();
    }

    public PsiMethod[] getMethods() {
        return this.myCache.getMethods();
    }

    @Override
    public GrMethod[] getCodeMethods() {
        return this.myCache.getCodeMethods();
    }

    public void subtreeChanged() {
        this.myCache.dropCaches();
        super.subtreeChanged();
    }

    public PsiMethod[] getConstructors() {
        return this.myCache.getConstructors();
    }

    @Override
    public GrMethod[] getCodeConstructors() {
        return this.myCache.getCodeConstructors();
    }

    public PsiClass[] getInnerClasses() {
        return this.myCache.getInnerClasses();
    }

    @Override
    public GrClassInitializer[] getInitializers() {
        GrTypeDefinitionBody body = this.getBody();
        return body != null ? body.getInitializers() : GrClassInitializer.EMPTY_ARRAY;
    }

    public PsiField[] getAllFields() {
        return GrClassImplUtil.getAllFields(this);
    }

    public PsiMethod[] getAllMethods() {
        return GrClassImplUtil.getAllMethods(this);
    }

    public PsiClass[] getAllInnerClasses() {
        return PsiClassImplUtil.getAllInnerClasses((PsiClass)this);
    }

    public PsiField findFieldByName(String name, boolean checkBases) {
        return GrClassImplUtil.findFieldByName(this, name, checkBases, true);
    }

    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
    }

    @Override
    public PsiMethod[] findCodeMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findCodeMethodsBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        return GrClassImplUtil.findMethodsByName(this, name, checkBases);
    }

    @Override
    public PsiMethod[] findCodeMethodsByName(@NonNls String name, boolean checkBases) {
        return GrClassImplUtil.findCodeMethodsByName(this, name, checkBases);
    }

    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        return GrClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
    }

    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        return GrClassImplUtil.getAllMethodsAndTheirSubstitutors(this);
    }

    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return GrClassImplUtil.findInnerClassByName(this, name, checkBases);
    }

    public PsiElement getLBrace() {
        GrTypeDefinitionBody body = this.getBody();
        return body == null ? null : body.getLBrace();
    }

    public PsiElement getRBrace() {
        GrTypeDefinitionBody body = this.getBody();
        return body == null ? null : body.getRBrace();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this);
    }

    public PsiElement getScope() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        ASTNode treeElement = this.getNode();
        for (ASTNode parent = treeElement.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (!(parent.getElementType() instanceof IStubElementType) || parent.getElementType() == GroovyElementTypes.CLASS_BODY) continue;
            return parent.getPsi();
        }
        return this.getContainingFile();
    }

    public boolean isInheritor(PsiClass baseClass, boolean checkDeep) {
        if (this.isTrait() && baseClass.isInterface() && !checkDeep) {
            for (PsiClassType superType : this.getImplementsListTypes()) {
                if (!this.getManager().areElementsEquivalent((PsiElement)superType.resolve(), (PsiElement)baseClass)) continue;
                return true;
            }
        }
        return InheritanceImplUtil.isInheritor((PsiClass)this, (PsiClass)baseClass, (boolean)checkDeep);
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep((PsiClass)this, (PsiClass)baseClass, (PsiClass)classToByPass);
    }

    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent = this.getParent();
        if (parent instanceof GrTypeDefinitionBody && (pparent = parent.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        return null;
    }

    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        return PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)this);
    }

    public PsiElement setName(@NonNls String name) throws IncorrectOperationException {
        boolean renameFile = this.isRenameFileOnClassRenaming();
        String oldName = this.getName();
        PsiImplUtil.setName(name, this.getNameIdentifierGroovy());
        GrTypeDefinitionBody body = this.getBody();
        if (body != null) {
            for (GrMethod method : body.getMethods()) {
                if (!method.isConstructor() || !method.getName().equals(oldName)) continue;
                method.setName(name);
            }
        }
        if (renameFile) {
            PsiFile file = this.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            String ext = virtualFile != null ? virtualFile.getExtension() : GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension();
            file.setName(name + "." + ext);
        }
        return this;
    }

    @Override
    public GrModifierList getModifierList() {
        return (GrModifierList)this.getStubOrPsiChild(GroovyElementTypes.MODIFIERS);
    }

    public boolean hasModifierProperty(@NonNls String name) {
        GrModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name);
    }

    @Override
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }

    @Override
    public boolean isDeprecated() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecatedByDoc() || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public boolean hasTypeParameters() {
        return this.getTypeParameters().length > 0;
    }

    @Override
    public GrTypeParameterList getTypeParameterList() {
        return (GrTypeParameterList)this.getStubOrPsiChild((IStubElementType)GroovyElementTypes.TYPE_PARAMETER_LIST);
    }

    public GrTypeParameter[] getTypeParameters() {
        GrTypeParameterList list = this.getTypeParameterList();
        if (list != null) {
            return list.getTypeParameters();
        }
        return GrTypeParameter.EMPTY_ARRAY;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.getIconInner();
        boolean isLocked = (flags & 2) != 0 && !this.isWritable();
        RowIcon rowIcon = GrTypeDefinitionImpl.createLayeredIcon((Iconable)this, (Icon)icon, (int)(ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)isLocked) | this.getFlagsInner()));
        if ((flags & 1) != 0) {
            VisibilityIcons.setVisibilityIcon((PsiModifierList)this.getModifierList(), (RowIcon)rowIcon);
        }
        return rowIcon;
    }

    private int getFlagsInner() {
        return !DumbService.isDumb((Project)this.getProject()) && GroovyRunnerPsiUtil.isRunnable(this) ? 16384 : 0;
    }

    private Icon getIconInner() {
        if (this.isAnnotationType()) {
            return JetgroovyIcons.Groovy.AnnotationType;
        }
        if (this.isTrait()) {
            return JetgroovyIcons.Groovy.Trait;
        }
        if (this.isInterface()) {
            return JetgroovyIcons.Groovy.Interface;
        }
        if (this.isEnum()) {
            return JetgroovyIcons.Groovy.Enum;
        }
        if (this.hasModifierProperty("abstract")) {
            return JetgroovyIcons.Groovy.AbstractClass;
        }
        return JetgroovyIcons.Groovy.Class;
    }

    private boolean isRenameFileOnClassRenaming() {
        PsiFile file = this.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        if (groovyFile.isScript()) {
            return false;
        }
        String name = this.getName();
        VirtualFile vFile = groovyFile.getVirtualFile();
        return vFile != null && name != null && name.equals(vFile.getNameWithoutExtension());
    }

    public PsiElement getOriginalElement() {
        return JavaPsiImplementationHelper.getInstance((Project)this.getProject()).getOriginalClass((PsiClass)this);
    }

    public PsiElement addAfter(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            return this.add(element);
        }
        GrTypeDefinitionBody body = this.getBody();
        if (anchor.getParent() == body) {
            PsiElement nextChild = anchor.getNextSibling();
            if (nextChild == null) {
                return this.add(element);
            }
            if (body == null) {
                throw new IncorrectOperationException("Class must have body");
            }
            return body.addBefore(element, nextChild);
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement addBefore(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            return this.add(element);
        }
        GrTypeDefinitionBody body = this.getBody();
        if (anchor.getParent() != body) {
            return super.addBefore(element, anchor);
        }
        if (body == null) {
            throw new IncorrectOperationException("Class must have body");
        }
        return body.addBefore(element, anchor);
    }

    public PsiElement add(PsiElement psiElement) throws IncorrectOperationException {
        PsiElement anchor;
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            throw new IncorrectOperationException("Class must have body");
        }
        PsiElement lBrace = body.getLBrace();
        if (lBrace == null) {
            throw new IncorrectOperationException("No left brace");
        }
        PsiMember member = GrTypeDefinitionImpl.getAnyMember(psiElement);
        PsiElement psiElement2 = anchor = member != null ? this.getDefaultAnchor(body, member) : null;
        if (anchor == null) {
            anchor = lBrace.getNextSibling();
        }
        if (anchor != null) {
            ASTNode node = anchor.getNode();
            assert (node != null);
            if (GroovyTokenTypes.mSEMI.equals(node.getElementType())) {
                anchor = anchor.getNextSibling();
            }
            if (psiElement instanceof GrField) {
                int i = ArrayUtilRt.find((Object[])((GrVariableDeclaration)psiElement.getParent()).getVariables(), (Object)psiElement);
                psiElement = body.addBefore(psiElement.getParent(), anchor);
                GrVariable[] vars = ((GrVariableDeclaration)psiElement).getVariables();
                for (int j = 0; j < vars.length; ++j) {
                    if (i == j) continue;
                    vars[i].delete();
                }
                psiElement = vars[i];
            } else {
                psiElement = body.addBefore(psiElement, anchor);
            }
        } else {
            psiElement = body.add(psiElement);
        }
        return psiElement;
    }

    private static PsiMember getAnyMember(PsiElement psiElement) {
        GrMember[] members;
        if (psiElement instanceof PsiMember) {
            return (PsiMember)psiElement;
        }
        if (psiElement instanceof GrVariableDeclaration && (members = ((GrVariableDeclaration)psiElement).getMembers()).length > 0) {
            return members[0];
        }
        return null;
    }

    public static int getMemberOrderWeight(PsiElement member, GroovyCodeStyleSettingsFacade settings) {
        if (member instanceof PsiField) {
            if (member instanceof PsiEnumConstant) {
                return 1;
            }
            return ((PsiField)member).hasModifierProperty("static") ? settings.staticFieldsOrderWeight() + 1 : settings.fieldsOrderWeight() + 1;
        }
        if (member instanceof PsiMethod) {
            if (((PsiMethod)member).isConstructor()) {
                return settings.constructorsOrderWeight() + 1;
            }
            return ((PsiMethod)member).hasModifierProperty("static") ? settings.staticMethodsOrderWeight() + 1 : settings.methodsOrderWeight() + 1;
        }
        if (member instanceof PsiClass) {
            return ((PsiClass)member).hasModifierProperty("static") ? settings.staticInnerClassesOrderWeight() + 1 : settings.innerClassesOrderWeight() + 1;
        }
        return -1;
    }

    private PsiElement getDefaultAnchor(GrTypeDefinitionBody body, PsiMember member) {
        GroovyCodeStyleSettingsFacade settings = GroovyCodeStyleSettingsFacade.getInstance(this.getProject());
        int order = GrTypeDefinitionImpl.getMemberOrderWeight((PsiElement)member, settings);
        if (order < 0) {
            return null;
        }
        PsiElement lastMember = null;
        for (PsiElement child = body.getFirstChild(); child != null; child = child.getNextSibling()) {
            int order1 = GrTypeDefinitionImpl.getMemberOrderWeight((PsiElement)GrTypeDefinitionImpl.getAnyMember(child), settings);
            if (order1 < 0) continue;
            if (order1 > order) {
                PsiElement lBrace = body.getLBrace();
                if (lastMember != null) {
                    PsiElement nextSibling = lastMember.getNextSibling();
                    while (nextSibling instanceof LeafPsiElement && (nextSibling.getText().equals(",") || nextSibling.getText().equals(";"))) {
                        nextSibling = nextSibling.getNextSibling();
                    }
                    return nextSibling == null && lBrace != null ? PsiUtil.skipWhitespacesAndComments(lBrace.getNextSibling(), true) : nextSibling;
                }
                if (lBrace != null) {
                    return PsiUtil.skipWhitespacesAndComments(lBrace.getNextSibling(), true);
                }
            }
            lastMember = child;
        }
        return body.getRBrace();
    }
}

