/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AstTransformContributor;

public class GrTypeDefinitionMembersCache {
    private static final Logger LOG = Logger.getInstance(GrTypeDefinitionMembersCache.class);
    private static final Condition<PsiMethod> CONSTRUCTOR_CONDITION = new Condition<PsiMethod>(){

        public boolean value(PsiMethod method) {
            return method.isConstructor();
        }
    };
    private final SimpleModificationTracker myTreeChangeTracker = new SimpleModificationTracker();
    private final GrTypeDefinition myDefinition;

    public GrTypeDefinitionMembersCache(GrTypeDefinition definition) {
        this.myDefinition = definition;
    }

    public GrMethod[] getCodeMethods() {
        return (GrMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<GrMethod[]>(){

            public CachedValueProvider.Result<GrMethod[]> compute() {
                GrTypeDefinitionBody body = GrTypeDefinitionMembersCache.this.myDefinition.getBody();
                GrMethod[] methods = body != null ? body.getMethods() : GrMethod.EMPTY_ARRAY;
                return CachedValueProvider.Result.create((Object)methods, (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker});
            }
        });
    }

    public GrMethod[] getCodeConstructors() {
        return (GrMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<GrMethod[]>(){

            public CachedValueProvider.Result<GrMethod[]> compute() {
                GrMethod[] methods;
                GrTypeDefinitionBody body = GrTypeDefinitionMembersCache.this.myDefinition.getBody();
                if (body != null) {
                    List result = ContainerUtil.findAll((Object[])body.getMethods(), (Condition)CONSTRUCTOR_CONDITION);
                    methods = result.toArray(new GrMethod[result.size()]);
                } else {
                    methods = GrMethod.EMPTY_ARRAY;
                }
                return CachedValueProvider.Result.create((Object)methods, (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker});
            }
        });
    }

    public PsiMethod[] getConstructors() {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            public CachedValueProvider.Result<PsiMethod[]> compute() {
                List result = ContainerUtil.findAll((Object[])GrTypeDefinitionMembersCache.this.myDefinition.getMethods(), (Condition)CONSTRUCTOR_CONDITION);
                return CachedValueProvider.Result.create((Object)result.toArray(new PsiMethod[result.size()]), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public PsiClass[] getInnerClasses() {
        return (PsiClass[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<PsiClass[]>(){

            public CachedValueProvider.Result<PsiClass[]> compute() {
                GrTypeDefinitionBody body = GrTypeDefinitionMembersCache.this.myDefinition.getBody();
                PsiClass[] inners = body != null ? body.getInnerClasses() : PsiClass.EMPTY_ARRAY;
                return CachedValueProvider.Result.create((Object)inners, (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker});
            }
        });
    }

    public GrField[] getFields() {
        return (GrField[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<GrField[]>(){

            public CachedValueProvider.Result<GrField[]> compute() {
                List fields = GrTypeDefinitionMembersCache.this.getFieldsImpl();
                return CachedValueProvider.Result.create((Object)fields.toArray(new GrField[fields.size()]), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    private List<GrField> getFieldsImpl() {
        ArrayList fields = ContainerUtil.newArrayList((Object[])this.myDefinition.getCodeFields());
        fields.addAll(new TraitCollector().collectFields());
        fields.addAll(this.getSyntheticFields());
        return fields;
    }

    private List<GrField> getSyntheticFields() {
        return (List)CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<List<GrField>>(){

            public CachedValueProvider.Result<List<GrField>> compute() {
                return CachedValueProvider.Result.create(AstTransformContributor.runContributorsForFields(GrTypeDefinitionMembersCache.this.myDefinition), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public PsiMethod[] getMethods() {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            public CachedValueProvider.Result<PsiMethod[]> compute() {
                ArrayList result = ContainerUtil.newArrayList();
                GrClassImplUtil.collectMethodsFromBody(GrTypeDefinitionMembersCache.this.myDefinition, result);
                result.addAll(new TraitCollector().collectMethods(result));
                for (PsiMethod method : AstTransformContributor.runContributorsForMethods(GrTypeDefinitionMembersCache.this.myDefinition)) {
                    GrClassImplUtil.addExpandingReflectedMethods(result, method);
                }
                for (GrField field : GrTypeDefinitionMembersCache.this.getSyntheticFields()) {
                    if (!field.isProperty()) continue;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)field.getSetter());
                    Collections.addAll(result, field.getGetters());
                }
                return CachedValueProvider.Result.create((Object)result.toArray(new PsiMethod[result.size()]), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public void dropCaches() {
        this.myTreeChangeTracker.incModificationCount();
    }

    private class TraitCollector {
        private TraitCollector() {
        }

        public List<PsiMethod> collectMethods(List<PsiMethod> codeMethods) {
            if (GrTypeDefinitionMembersCache.this.myDefinition.isInterface() && !GrTypeDefinitionMembersCache.this.myDefinition.isTrait()) {
                return Collections.emptyList();
            }
            GrImplementsClause clause = GrTypeDefinitionMembersCache.this.myDefinition.getImplementsClause();
            if (clause == null) {
                return Collections.emptyList();
            }
            PsiClassType[] types = clause.getReferencedTypes();
            List<PsiClassType.ClassResolveResult> traits = this.getSuperTraitsByCorrectOrder(types);
            if (traits.isEmpty()) {
                return Collections.emptyList();
            }
            HashSet existingSignatures = ContainerUtil.newHashSet((Iterable)ContainerUtil.map(codeMethods, (Function)new Function<PsiMethod, MethodSignature>(){

                public MethodSignature fun(PsiMethod method) {
                    return method.getSignature(PsiSubstitutor.EMPTY);
                }
            }));
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiClassType.ClassResolveResult resolveResult : traits) {
                GrTypeDefinition trait = (GrTypeDefinition)resolveResult.getElement();
                LOG.assertTrue(trait != null);
                List<CandidateInfo> concreteTraitMethods = new TraitProcessor<PsiMethod>(trait, resolveResult.getSubstitutor()){

                    @Override
                    protected void processTrait(GrTypeDefinition trait, PsiSubstitutor substitutor) {
                        for (GrMethod grMethod : trait.getCodeMethods()) {
                            if (grMethod.getModifierList().hasExplicitModifier("abstract")) continue;
                            this.addCandidate(grMethod, substitutor);
                        }
                        for (GrDocCommentOwner grDocCommentOwner : trait.getCodeFields()) {
                            if (!grDocCommentOwner.isProperty()) continue;
                            for (GrAccessorMethod method : grDocCommentOwner.getGetters()) {
                                this.addCandidate(method, substitutor);
                            }
                            GrAccessorMethod setter = grDocCommentOwner.getSetter();
                            if (setter == null) continue;
                            this.addCandidate(setter, substitutor);
                        }
                    }
                }.getResult();
                for (CandidateInfo candidateInfo : concreteTraitMethods) {
                    List<GrMethod> methodsToAdd = this.getExpandingMethods(candidateInfo);
                    for (GrMethod impl : methodsToAdd) {
                        if (!existingSignatures.add(impl.getSignature(PsiSubstitutor.EMPTY))) continue;
                        result.add(impl);
                    }
                }
            }
            return result;
        }

        public List<GrField> collectFields() {
            GrImplementsClause clause;
            if (GrTypeDefinitionMembersCache.this.myDefinition.isInterface() && !GrTypeDefinitionMembersCache.this.myDefinition.isTrait()) {
                return Collections.emptyList();
            }
            ArrayList result = ContainerUtil.newArrayList();
            if (GrTypeDefinitionMembersCache.this.myDefinition.isTrait()) {
                for (GrField field : GrTypeDefinitionMembersCache.this.myDefinition.getCodeFields()) {
                    result.add(new GrTraitField(field, GrTypeDefinitionMembersCache.this.myDefinition, PsiSubstitutor.EMPTY));
                }
            }
            if ((clause = GrTypeDefinitionMembersCache.this.myDefinition.getImplementsClause()) == null) {
                return result;
            }
            PsiClassType[] types = clause.getReferencedTypes();
            List<PsiClassType.ClassResolveResult> traits = this.getSuperTraitsByCorrectOrder(types);
            for (PsiClassType.ClassResolveResult resolveResult : traits) {
                GrTypeDefinition trait = (GrTypeDefinition)resolveResult.getElement();
                LOG.assertTrue(trait != null);
                List<CandidateInfo> traitFields = new TraitProcessor<PsiField>(trait, resolveResult.getSubstitutor()){

                    @Override
                    protected void processTrait(GrTypeDefinition trait, PsiSubstitutor substitutor) {
                        for (GrField field : trait.getCodeFields()) {
                            this.addCandidate(field, substitutor);
                        }
                    }
                }.getResult();
                for (CandidateInfo candidateInfo : traitFields) {
                    result.add(new GrTraitField((PsiField)candidateInfo.getElement(), GrTypeDefinitionMembersCache.this.myDefinition, candidateInfo.getSubstitutor()));
                }
            }
            if (GrTypeDefinitionMembersCache.this.myDefinition.isTrait()) {
                for (GrField field : GrTypeDefinitionMembersCache.this.myDefinition.getCodeFields()) {
                    result.add(new GrTraitField(field, GrTypeDefinitionMembersCache.this.myDefinition, PsiSubstitutor.EMPTY));
                }
            }
            return result;
        }

        private List<GrMethod> getExpandingMethods(CandidateInfo candidateInfo) {
            PsiMethod method = (PsiMethod)candidateInfo.getElement();
            GrLightMethodBuilder implementation = GrTraitMethod.create(method, candidateInfo.getSubstitutor()).setContainingClass(GrTypeDefinitionMembersCache.this.myDefinition);
            implementation.getModifierList().removeModifier(1024);
            GrReflectedMethod[] reflectedMethods = implementation.getReflectedMethods();
            return reflectedMethods.length > 0 ? Arrays.asList(reflectedMethods) : Collections.singletonList(implementation);
        }

        private List<PsiClassType.ClassResolveResult> getSuperTraitsByCorrectOrder(PsiClassType[] types) {
            ArrayList traits = ContainerUtil.newArrayList();
            for (int i = types.length - 1; i >= 0; --i) {
                PsiClassType.ClassResolveResult resolveResult = types[i].resolveGenerics();
                PsiClass superClass = resolveResult.getElement();
                if (!GrTraitUtil.isTrait(superClass)) continue;
                traits.add(resolveResult);
            }
            return traits;
        }

        private abstract class TraitProcessor<T extends PsiElement> {
            private final ArrayList<CandidateInfo> result = ContainerUtil.newArrayList();
            private final Set<PsiClass> processed = ContainerUtil.newHashSet();

            public TraitProcessor(GrTypeDefinition superClass, PsiSubstitutor substitutor) {
                this.process(superClass, substitutor);
            }

            public List<CandidateInfo> getResult() {
                return this.result;
            }

            private void process(GrTypeDefinition trait, PsiSubstitutor substitutor) {
                assert (trait.isTrait());
                if (!this.processed.add(trait)) {
                    return;
                }
                this.processTrait(trait, substitutor);
                List traits = TraitCollector.this.getSuperTraitsByCorrectOrder(trait.getSuperTypes());
                for (PsiClassType.ClassResolveResult resolveResult : traits) {
                    PsiClass superClass = resolveResult.getElement();
                    if (!GrTraitUtil.isTrait(superClass)) continue;
                    PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)trait, (PsiSubstitutor)substitutor);
                    this.process((GrTypeDefinition)superClass, superSubstitutor);
                }
            }

            protected abstract void processTrait(GrTypeDefinition var1, PsiSubstitutor var2);

            protected void addCandidate(T element, PsiSubstitutor substitutor) {
                this.result.add(new CandidateInfo(element, substitutor));
            }
        }
    }
}

