/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.enumConstant;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumConstantInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrFieldImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrEnumConstantImpl
extends GrFieldImpl
implements GrEnumConstant {
    private final MyReference myReference = new MyReference();

    public GrEnumConstantImpl(ASTNode node) {
        super(node);
    }

    public GrEnumConstantImpl(GrFieldStub stub) {
        super(stub, GroovyElementTypes.ENUM_CONSTANT);
    }

    @Override
    public String toString() {
        return "Enumeration constant";
    }

    @Override
    public boolean hasModifierProperty(@NonNls String property) {
        if (property.equals("static")) {
            return true;
        }
        if (property.equals("public")) {
            return true;
        }
        return property.equals("final");
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitEnumConstant(this);
    }

    @Override
    public GrTypeElement getTypeElementGroovy() {
        return null;
    }

    @Override
    public PsiType getType() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(this.getContainingClass(), PsiSubstitutor.EMPTY);
    }

    @Override
    public PsiType getTypeGroovy() {
        return this.getType();
    }

    @Override
    public void setType(PsiType type) {
        throw new RuntimeException("Cannot set type for enum constant");
    }

    @Override
    public GrExpression getInitializerGroovy() {
        return null;
    }

    @Override
    public boolean isProperty() {
        return false;
    }

    @Override
    public GroovyResolveResult[] multiResolveClass() {
        GroovyResolveResultImpl result = new GroovyResolveResultImpl((PsiElement)this.getContainingClass(), this, null, PsiSubstitutor.EMPTY, true, true);
        return new GroovyResolveResult[]{result};
    }

    @Override
    public GrArgumentList getArgumentList() {
        return (GrArgumentList)this.findChildByClass(GrArgumentList.class);
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) throws IncorrectOperationException {
        GrArgumentList list = this.getArgumentList();
        assert (list != null);
        if (list.getText().trim().isEmpty()) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            GrArgumentList newList = factory.createArgumentList();
            list = (GrArgumentList)list.replace(newList);
        }
        return list.addNamedArgument(namedArgument);
    }

    @Override
    public GrNamedArgument[] getNamedArguments() {
        GrArgumentList argumentList = this.getArgumentList();
        return argumentList == null ? GrNamedArgument.EMPTY_ARRAY : argumentList.getNamedArguments();
    }

    @Override
    public GrExpression[] getExpressionArguments() {
        GrArgumentList argumentList = this.getArgumentList();
        return argumentList == null ? GrExpression.EMPTY_ARRAY : argumentList.getExpressionArguments();
    }

    @Override
    public GroovyResolveResult[] getCallVariants(GrExpression upToArgument) {
        return this.multiResolve(true);
    }

    @Override
    public GrClosableBlock[] getClosureArguments() {
        return GrClosableBlock.EMPTY_ARRAY;
    }

    @Override
    public PsiMethod resolveMethod() {
        return PsiImplUtil.extractUniqueElement(this.multiResolve(false));
    }

    public JavaResolveResult resolveMethodGenerics() {
        return JavaResolveResult.EMPTY;
    }

    @Override
    public GrEnumConstantInitializer getInitializingClass() {
        return (GrEnumConstantInitializer)this.findChildByClass(GrEnumConstantInitializer.class);
    }

    public PsiEnumConstantInitializer getOrCreateInitializingClass() {
        GrEnumConstantInitializer initializingClass = this.getInitializingClass();
        if (initializingClass != null) {
            return initializingClass;
        }
        GrEnumConstantInitializer initializer = GroovyPsiElementFactory.getInstance(this.getProject()).createEnumConstantFromText("foo{}").getInitializingClass();
        LOG.assertTrue(initializer != null);
        GrArgumentList argumentList = this.getArgumentList();
        if (argumentList != null) {
            return (PsiEnumConstantInitializer)this.addAfter(initializer, argumentList);
        }
        return (PsiEnumConstantInitializer)this.addAfter(initializer, this.getNameIdentifierGroovy());
    }

    public PsiReference getReference() {
        return this.myReference;
    }

    @Override
    public GroovyResolveResult advancedResolve() {
        return PsiImplUtil.extractUniqueResult(this.multiResolve(false));
    }

    public PsiMethod resolveConstructor() {
        return this.resolveMethod();
    }

    @Override
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        PsiType[] argTypes = PsiUtil.getArgumentTypes(this.getFirstChild(), false);
        PsiClass clazz = this.getContainingClass();
        return ResolveUtil.getAllClassConstructors(clazz, PsiSubstitutor.EMPTY, argTypes, this);
    }

    @Override
    public PsiClass getContainingClass() {
        PsiClass aClass = super.getContainingClass();
        assert (aClass != null);
        return aClass;
    }

    private class MyReference
    implements PsiPolyVariantReference {
        private MyReference() {
        }

        public ResolveResult[] multiResolve(boolean incompleteCode) {
            return GrEnumConstantImpl.this.multiResolve(false);
        }

        public PsiElement getElement() {
            return GrEnumConstantImpl.this;
        }

        public TextRange getRangeInElement() {
            return GrEnumConstantImpl.this.getNameIdentifierGroovy().getTextRange().shiftRight(-GrEnumConstantImpl.this.getTextOffset());
        }

        public PsiElement resolve() {
            return GrEnumConstantImpl.this.resolveMethod();
        }

        public GroovyResolveResult advancedResolve() {
            return GrEnumConstantImpl.this.advancedResolve();
        }

        public String getCanonicalText() {
            return GrEnumConstantImpl.this.getContainingClass().getName();
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return this.getElement();
        }

        public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
            throw new IncorrectOperationException("invalid operation");
        }

        public boolean isReferenceTo(PsiElement element) {
            return element instanceof GrMethod && ((GrMethod)element).isConstructor() && GrEnumConstantImpl.this.getManager().areElementsEquivalent(this.resolve(), element);
        }

        public Object[] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }
    }
}

