/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameterListBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrReflectedMethodImpl;

public class GrLightMethodBuilder
extends LightElement
implements GrMethod,
OriginInfoAwareElement {
    public static final Key<String> KIND_KEY = Key.create((String)"GrLightMethodBuilder.Key");
    protected String myName;
    private PsiType myReturnType = PsiType.VOID;
    private final GrLightModifierList myModifierList;
    private final GrLightParameterListBuilder myParameterList;
    private final LightTypeParameterListBuilder myTypeParameterList;
    private final LightReferenceListBuilder myThrowsList;
    private boolean myConstructor = false;
    private PsiClass myContainingClass;
    private Map<String, NamedArgumentDescriptor> myNamedParameters = Collections.emptyMap();
    private Icon myBaseIcon;
    private Object myMethodKind;
    private Object myData;
    private String myOriginInfo;

    public GrLightMethodBuilder(PsiManager manager, String name) {
        super(manager, (Language)GroovyLanguage.INSTANCE);
        this.myName = name;
        this.myModifierList = new GrLightModifierList(this);
        this.myParameterList = new GrLightParameterListBuilder(manager, GroovyLanguage.INSTANCE);
        this.myTypeParameterList = new LightTypeParameterListBuilder(manager, (Language)GroovyLanguage.INSTANCE);
        this.myThrowsList = new LightReferenceListBuilder(manager, (Language)GroovyLanguage.INSTANCE, PsiReferenceList.Role.THROWS_LIST);
    }

    public GrLightMethodBuilder setNamedParameters(Map<String, NamedArgumentDescriptor> namedParameters) {
        this.myNamedParameters = namedParameters;
        return this;
    }

    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getMethodPresentation((PsiMethod)this);
    }

    @Override
    public boolean hasTypeParameters() {
        return false;
    }

    @Override
    public PsiTypeParameter[] getTypeParameters() {
        return this.getTypeParameterList().getTypeParameters();
    }

    public LightTypeParameterListBuilder getTypeParameterList() {
        return this.myTypeParameterList;
    }

    @Override
    public GrDocComment getDocComment() {
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    public PsiElement setName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Please don't rename light methods");
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        return PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
    }

    public boolean hasModifierProperty(@GrModifier.GrModifierConstant String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public GrMember[] getMembers() {
        return GrMember.EMPTY_ARRAY;
    }

    @Override
    public GrLightModifierList getModifierList() {
        return this.myModifierList;
    }

    @Override
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        return this.myNamedParameters;
    }

    @Override
    public GrReflectedMethod[] getReflectedMethods() {
        return (GrReflectedMethod[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<GrReflectedMethod[]>(){

            public CachedValueProvider.Result<GrReflectedMethod[]> compute() {
                return CachedValueProvider.Result.create((Object)GrReflectedMethodImpl.createReflectedMethods(GrLightMethodBuilder.this), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public GrLightMethodBuilder addModifier(String modifier) {
        this.getModifierList().addModifier(modifier);
        return this;
    }

    public GrLightMethodBuilder addModifier(int modifier) {
        this.getModifierList().addModifier(modifier);
        return this;
    }

    public GrLightMethodBuilder setModifiers(String[] modifiers) {
        this.getModifierList().setModifiers(modifiers);
        return this;
    }

    public GrLightMethodBuilder setModifiers(int modifiers) {
        this.getModifierList().setModifiers(modifiers);
        return this;
    }

    @Override
    public GrOpenBlock getBlock() {
        return null;
    }

    @Override
    public void setBlock(GrCodeBlock newBlock) {
        throw new IncorrectOperationException();
    }

    @Override
    public GrTypeElement getReturnTypeElementGroovy() {
        PsiType returnType = this.getReturnType();
        if (returnType == null) {
            return null;
        }
        return new GrLightTypeElement(returnType, this.getManager());
    }

    @Override
    public PsiType getInferredReturnType() {
        return this.getReturnType();
    }

    @Override
    public PsiType getReturnType() {
        return this.myReturnType;
    }

    public GrTypeElement setReturnType(String returnType, GlobalSearchScope scope) {
        this.setReturnType((PsiType)JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createTypeByFQClassName(returnType, scope));
        return null;
    }

    @Override
    public GrTypeElement setReturnType(PsiType returnType) {
        this.myReturnType = returnType;
        return null;
    }

    public PsiTypeElement getReturnTypeElement() {
        return null;
    }

    @Override
    public GrParameter[] getParameters() {
        return this.getParameterList().getParameters();
    }

    @Override
    public GrLightParameterListBuilder getParameterList() {
        return this.myParameterList;
    }

    public GrLightMethodBuilder addParameter(GrParameter parameter) {
        this.getParameterList().addParameter(parameter);
        return this;
    }

    public GrLightMethodBuilder addParameter(String name, String type, boolean isOptional) {
        return this.addParameter(name, JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeFromText(type, (PsiElement)this), isOptional);
    }

    public GrLightMethodBuilder addParameter(String name, PsiType type, boolean isOptional) {
        GrLightParameter param = new GrLightParameter(name, type, this).setOptional(isOptional);
        return this.addParameter(param);
    }

    public LightReferenceListBuilder getThrowsList() {
        return this.myThrowsList;
    }

    public PsiCodeBlock getBody() {
        return null;
    }

    public boolean isConstructor() {
        return this.myConstructor;
    }

    public GrLightMethodBuilder setConstructor(boolean constructor) {
        this.myConstructor = constructor;
        return this;
    }

    @Override
    public boolean isVarArgs() {
        GrParameter[] parameters = this.getParameterList().getParameters();
        if (parameters.length == 0) {
            return false;
        }
        return parameters[parameters.length - 1].isVarArgs();
    }

    public MethodSignature getSignature(PsiSubstitutor substitutor) {
        return MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    public PsiMethod[] findSuperMethods() {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this);
    }

    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (boolean)checkAccess);
    }

    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (PsiClass)parentClass);
    }

    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic((PsiMethod)this, (boolean)checkAccess);
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod((PsiMethod)this);
    }

    public PsiMethod[] findDeepestSuperMethods() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethods((PsiMethod)this);
    }

    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        }
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public GrLightMethodBuilder setContainingClass(PsiClass containingClass) {
        this.myContainingClass = containingClass;
        return this;
    }

    public Object getMethodKind() {
        return this.myMethodKind;
    }

    public GrLightMethodBuilder setMethodKind(Object methodKind) {
        this.myMethodKind = methodKind;
        return this;
    }

    @Override
    public PsiElement getNameIdentifierGroovy() {
        return new LightIdentifier(this.getManager(), this.getName());
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
    }

    public static Object getMethodKind(PsiElement method) {
        if (method == null) {
            return null;
        }
        if (method instanceof GrLightMethodBuilder) {
            return ((GrLightMethodBuilder)method).getMethodKind();
        }
        return method.getUserData(KIND_KEY);
    }

    public static boolean checkKind(PsiElement method, Object kind) {
        return kind.equals(GrLightMethodBuilder.getMethodKind(method));
    }

    public static boolean checkKind(PsiElement method, Object kind1, Object kind2) {
        Object kind = GrLightMethodBuilder.getMethodKind(method);
        return kind1.equals(kind) || kind2.equals(kind);
    }

    public String toString() {
        return (this.myMethodKind == null ? "" : this.myMethodKind + ":") + this.getName();
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.myBaseIcon != null ? this.myBaseIcon : (this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON);
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon((Icon)methodIcon, (PsiModifierListOwner)this, (boolean)false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }

    public GrLightMethodBuilder setBaseIcon(Icon baseIcon) {
        this.myBaseIcon = baseIcon;
        return this;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo((PsiMethod)this, (PsiElement)another) || this.getNavigationElement() == another;
    }

    public SearchScope getUseScope() {
        return PsiImplUtil.getMemberUseScope((PsiMember)this);
    }

    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        return containingClass == null ? null : containingClass.getContainingFile();
    }

    public PsiElement getContext() {
        PsiElement navElement = this.getNavigationElement();
        if (navElement != this) {
            return navElement;
        }
        PsiClass cls = this.getContainingClass();
        if (cls != null) {
            return cls;
        }
        return this.getContainingFile();
    }

    protected void copyData(GrLightMethodBuilder dst) {
        dst.setMethodKind(this.getMethodKind());
        dst.setData(this.getData());
        dst.setNamedParameters(this.getNamedParameters());
        if (this.getNavigationElement() != this) {
            dst.setNavigationElement(this.getNavigationElement());
        }
        dst.setBaseIcon(this.myBaseIcon);
        dst.setReturnType(this.getReturnType());
        dst.setContainingClass(this.getContainingClass());
        dst.getModifierList().copyModifiers(this);
        dst.getParameterList().clear();
        for (GrParameter parameter : this.getParameterList().getParameters()) {
            dst.addParameter(parameter);
        }
    }

    public GrLightMethodBuilder copy() {
        GrLightMethodBuilder copy = new GrLightMethodBuilder(this.myManager, this.myName);
        this.copyData(copy);
        return copy;
    }

    public <T> T getData() {
        return (T)this.myData;
    }

    public static <T> T getData(PsiElement method, Object kind) {
        if (method instanceof GrLightMethodBuilder && kind.equals(((GrLightMethodBuilder)method).getMethodKind())) {
            return ((GrLightMethodBuilder)method).getData();
        }
        return null;
    }

    public GrLightMethodBuilder setData(Object data) {
        this.myData = data;
        return this;
    }

    public GrLightMethodBuilder addException(PsiClassType type) {
        this.getThrowsList().addReference(type);
        return this;
    }

    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(String originInfo) {
        this.myOriginInfo = originInfo;
    }
}

