/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;

public class GrLightModifierList
extends LightElement
implements GrModifierList {
    private int myModifiers;
    private final List<GrAnnotation> myAnnotations = new ArrayList<GrAnnotation>();
    private final PsiElement myParent;

    public GrLightModifierList(PsiElement parent) {
        super(parent.getManager(), parent.getLanguage());
        this.myParent = parent;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public void addModifier(String modifier) {
        int code = GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)modifier);
        assert (code != 0);
        this.myModifiers |= code;
    }

    public void addModifier(int modifier) {
        this.myModifiers |= modifier;
    }

    public void removeModifier(int modifier) {
        this.myModifiers &= ~modifier;
    }

    public void setModifiers(int modifiers) {
        this.myModifiers = modifiers;
    }

    public void setModifiers(String ... modifiers) {
        this.myModifiers = 0;
        for (String modifier : modifiers) {
            this.addModifier(modifier);
        }
    }

    public int getModifiersAsInt() {
        return this.myModifiers;
    }

    @Override
    public boolean hasModifierProperty(String name) {
        return GrModifierListImpl.checkModifierProperty(this, name);
    }

    @Override
    public boolean hasExplicitModifier(String name) {
        return (this.myModifiers & GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)name)) != 0;
    }

    @Override
    public void setModifierProperty(String name, boolean value) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public GrAnnotation[] getRawAnnotations() {
        return this.getAnnotations();
    }

    public void checkSetModifierProperty(String name, boolean value) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public GrAnnotation[] getAnnotations() {
        return this.myAnnotations.toArray(new GrAnnotation[this.myAnnotations.size()]);
    }

    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    public PsiAnnotation findAnnotation(String qualifiedName) {
        return null;
    }

    public PsiAnnotation addAnnotation(@NonNls String qualifiedName) {
        GrLightAnnotation annotation = new GrLightAnnotation(this.getManager(), this.getLanguage(), qualifiedName, (PsiAnnotationOwner)this);
        this.myAnnotations.add(annotation);
        return annotation;
    }

    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList((PsiModifierList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "GrModifierList";
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (GrAnnotation annotation : this.myAnnotations) {
            buffer.append(annotation.getText());
            buffer.append(' ');
        }
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            buffer.append(modifier);
            buffer.append(' ');
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    @Override
    public PsiElement[] getModifiers() {
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public boolean hasExplicitVisibilityModifiers() {
        return (this.myModifiers & 7) != 0;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitModifierList(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
    }

    public void copyModifiers(PsiModifierListOwner modifierOwner) {
        int mod = 0;
        PsiModifierList modifierList = modifierOwner.getModifierList();
        if (modifierList != null) {
            if (modifierList instanceof GrLightModifierList) {
                mod = ((GrLightModifierList)modifierList).getModifiersAsInt();
            } else {
                for (Object o : ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.keys()) {
                    String modifier = (String)o;
                    if (!modifierList.hasExplicitModifier(modifier)) continue;
                    mod |= GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)modifier);
                }
            }
        }
        this.setModifiers(mod);
    }
}

