/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;

public class GroovyScriptClass
extends LightElement
implements PsiClass,
SyntheticElement {
    private final GroovyFile myFile;
    private volatile PsiMethod myMainMethod = null;
    private volatile PsiMethod myRunMethod = null;
    private volatile boolean myInitialized = false;
    private final LightModifierList myModifierList;

    public GroovyScriptClass(GroovyFile file) {
        super(file.getManager(), file.getLanguage());
        this.myFile = file;
        this.myModifierList = new LightModifierList(this.myManager, (Language)GroovyLanguage.INSTANCE, new String[]{"public"});
    }

    public String toString() {
        return "Script Class:" + this.getQualifiedName();
    }

    public String getText() {
        return "class " + this.getName() + " {}";
    }

    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass((PsiClass)this);
        }
    }

    public PsiElement copy() {
        return new GroovyScriptClass(this.myFile);
    }

    public GroovyFile getContainingFile() {
        return this.myFile;
    }

    public TextRange getTextRange() {
        return this.myFile.getTextRange();
    }

    public int getTextOffset() {
        return 0;
    }

    public boolean isValid() {
        return this.myFile.isValid() && this.myFile.isScript();
    }

    public String getQualifiedName() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        String packName = this.myFile.getPackageName();
        if (packName.isEmpty()) {
            return name;
        }
        return packName + "." + name;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isWritable() {
        return this.myFile.isWritable();
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public PsiElement add(PsiElement element) throws IncorrectOperationException {
        return this.myFile.add(element);
    }

    public PsiElement addAfter(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.myFile.addAfter(element, anchor);
    }

    public PsiElement addBefore(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.myFile.addBefore(element, anchor);
    }

    public PsiReferenceList getExtendsList() {
        return null;
    }

    public PsiReferenceList getImplementsList() {
        return null;
    }

    public PsiClassType[] getExtendsListTypes() {
        PsiClassType type = this.getSuperClassTypeFromBaseScriptAnnotatedVariable();
        if (type != null) {
            return new PsiClassType[]{type};
        }
        PsiClassType superClassFromDSL = GroovyDslFileIndex.pocessScriptSuperClasses(this.myFile);
        if (superClassFromDSL != null) {
            return new PsiClassType[]{superClassFromDSL};
        }
        PsiClassType superClass = TypesUtil.createTypeByFQClassName("groovy.lang.Script", (PsiElement)this);
        return new PsiClassType[]{superClass};
    }

    private PsiClassType getSuperClassTypeFromBaseScriptAnnotatedVariable() {
        return (PsiClassType)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)false, (Computable)new Computable<PsiClassType>(){

            public PsiClassType compute() {
                return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)GroovyScriptClass.this.myFile, (CachedValueProvider)new CachedValueProvider<PsiClassType>(){

                    public CachedValueProvider.Result<PsiClassType> compute() {
                        PsiType type;
                        GrTypeElement typeElement;
                        GrModifierList modifierList;
                        GrVariableDeclaration declaration = GroovyScriptClass.this.findDeclaration();
                        if (declaration != null && (modifierList = declaration.getModifierList()).findAnnotation("groovy.transform.BaseScript") != null && (typeElement = declaration.getTypeElementGroovy()) != null && (type = typeElement.getType()) instanceof PsiClassType) {
                            return CachedValueProvider.Result.create((Object)((PsiClassType)type), (Object[])new Object[]{GroovyScriptClass.this.myFile});
                        }
                        return CachedValueProvider.Result.create(null, (Object[])new Object[]{GroovyScriptClass.this.myFile});
                    }
                });
            }
        });
    }

    private GrVariableDeclaration findDeclaration() {
        final Ref ref = Ref.create();
        this.myFile.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitVariableDeclaration(GrVariableDeclaration variableDeclaration) {
                super.visitVariableDeclaration(variableDeclaration);
                if (variableDeclaration.getModifierList().findAnnotation("groovy.transform.BaseScript") != null) {
                    ref.set((Object)variableDeclaration);
                }
            }

            @Override
            public void visitElement(GroovyPsiElement element) {
                if (ref.isNull()) {
                    super.visitElement(element);
                }
            }
        });
        return (GrVariableDeclaration)ref.get();
    }

    public PsiClassType[] getImplementsListTypes() {
        return PsiClassType.EMPTY_ARRAY;
    }

    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass((PsiClass)this);
    }

    public PsiClass[] getInterfaces() {
        return PsiClassImplUtil.getInterfaces((PsiClass)this);
    }

    public PsiClass[] getSupers() {
        return PsiClassImplUtil.getSupers((PsiClass)this);
    }

    public PsiClassType[] getSuperTypes() {
        return PsiClassImplUtil.getSuperTypes((PsiClass)this);
    }

    public PsiClass getContainingClass() {
        return null;
    }

    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        return PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)this);
    }

    public PsiField[] getFields() {
        return GrScriptField.getScriptFields(this);
    }

    public PsiMethod[] getMethods() {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            public CachedValueProvider.Result<PsiMethod[]> compute() {
                PsiMethod[] methods;
                if (!GroovyScriptClass.this.myInitialized) {
                    GroovyScriptClass.this.initMethods();
                }
                int addMain = GroovyScriptClass.this.hasMain(methods = GroovyScriptClass.this.myFile.getMethods()) ? 0 : 1;
                int addRun = GroovyScriptClass.this.hasRun(methods) ? 0 : 1;
                PsiMethod[] result = GroovyScriptClass.this.initMethods(methods, addMain, addRun);
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{GroovyScriptClass.this.myFile});
            }
        });
    }

    private PsiMethod[] initMethods(PsiMethod[] methods, int addMain, int addRun) {
        if (addMain + addRun == 0) {
            return methods;
        }
        PsiMethod[] result = new PsiMethod[methods.length + addMain + addRun];
        if (addMain == 1) {
            result[0] = this.myMainMethod;
        }
        if (addRun == 1) {
            result[addMain] = this.myRunMethod;
        }
        System.arraycopy(methods, 0, result, addMain + addRun, methods.length);
        return result;
    }

    private boolean hasMain(PsiMethod[] methods) {
        assert (this.myMainMethod != null);
        return ContainerUtil.find((Object[])methods, (Condition)new Condition<PsiMethod>(){

            public boolean value(PsiMethod method) {
                return method.isEquivalentTo((PsiElement)GroovyScriptClass.this.myMainMethod);
            }
        }) != null;
    }

    private boolean hasRun(PsiMethod[] methods) {
        assert (this.myRunMethod != null);
        return ContainerUtil.find((Object[])methods, (Condition)new Condition<PsiMethod>(){

            public boolean value(PsiMethod method) {
                return method.isEquivalentTo((PsiElement)GroovyScriptClass.this.myRunMethod);
            }
        }) != null;
    }

    private synchronized void initMethods() {
        if (this.myInitialized) {
            return;
        }
        this.myMainMethod = new LightMethodBuilder(this.getManager(), (Language)GroovyLanguage.INSTANCE, "main").setContainingClass((PsiClass)this).setMethodReturnType((PsiType)PsiType.VOID).addParameter("args", (PsiType)new PsiArrayType((PsiType)PsiType.getJavaLangString((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope()))).addModifiers(new String[]{"public", "static"});
        this.myRunMethod = new LightMethodBuilder(this.getManager(), (Language)GroovyLanguage.INSTANCE, "run").setContainingClass((PsiClass)this).setMethodReturnType((PsiType)TypesUtil.getJavaLangObject((PsiElement)this)).addModifier("public");
        this.myInitialized = true;
    }

    public PsiMethod[] getConstructors() {
        return PsiMethod.EMPTY_ARRAY;
    }

    public PsiClass[] getInnerClasses() {
        return PsiClass.EMPTY_ARRAY;
    }

    public PsiClassInitializer[] getInitializers() {
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    public PsiTypeParameter[] getTypeParameters() {
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    public PsiField[] getAllFields() {
        return PsiClassImplUtil.getAllFields((PsiClass)this);
    }

    public PsiMethod[] getAllMethods() {
        return PsiClassImplUtil.getAllMethods((PsiClass)this);
    }

    public PsiClass[] getAllInnerClasses() {
        return PsiClassImplUtil.getAllInnerClasses((PsiClass)this);
    }

    public PsiField findFieldByName(String name, boolean checkBases) {
        return PsiClassImplUtil.findFieldByName((PsiClass)this, (String)name, (boolean)checkBases);
    }

    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature((PsiClass)this, (PsiMethod)patternMethod, (boolean)checkBases);
    }

    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodsBySignature((PsiClass)this, (PsiMethod)patternMethod, (boolean)checkBases);
    }

    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        return PsiClassImplUtil.findMethodsByName((PsiClass)this, (String)name, (boolean)checkBases);
    }

    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        return PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName((PsiClass)this, (String)name, (boolean)checkBases);
    }

    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        return PsiClassImplUtil.getAllWithSubstitutorsByMap((PsiClass)this, (PsiClassImplUtil.MemberType)PsiClassImplUtil.MemberType.METHOD);
    }

    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return PsiClassImplUtil.findInnerByName((PsiClass)this, (String)name, (boolean)checkBases);
    }

    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    public boolean hasTypeParameters() {
        return false;
    }

    public PsiJavaToken getLBrace() {
        return null;
    }

    public PsiJavaToken getRBrace() {
        return null;
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    public PsiElement getScope() {
        return this.myFile;
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep((PsiClass)this, (PsiClass)baseClass, (PsiClass)classToByPass);
    }

    public boolean isInheritor(PsiClass baseClass, boolean checkDeep) {
        return InheritanceImplUtil.isInheritor((PsiClass)this, (PsiClass)baseClass, (boolean)checkDeep);
    }

    public String getName() {
        String fileName = this.myFile.getName();
        String name = FileUtilRt.getNameWithoutExtension((String)fileName);
        if (StringUtil.isJavaIdentifier((String)name)) {
            return name;
        }
        return null;
    }

    public PsiElement setName(String name) throws IncorrectOperationException {
        this.myFile.setName(PathUtil.makeFileName((String)name, (String)this.myFile.getViewProvider().getVirtualFile().getExtension()));
        return this;
    }

    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    public boolean hasModifierProperty(String name) {
        return this.myModifierList.hasModifierProperty(name);
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean processDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return PsiClassImplUtil.processDeclarationsInClass((PsiClass)this, (PsiScopeProcessor)processor, (ResolveState)state, (Set)ContainerUtil.newHashSet(), (PsiElement)lastParent, (PsiElement)place, (LanguageLevel)PsiUtil.getLanguageLevel((PsiElement)place), (boolean)false);
    }

    public PsiElement getContext() {
        return this.myFile;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                String name = GroovyScriptClass.this.getName();
                return name != null ? name : "<unnamed>";
            }

            public String getLocationString() {
                String packageName = GroovyScriptClass.this.myFile.getPackageName();
                return "(groovy script" + (packageName.isEmpty() ? "" : ", " + packageName) + ")";
            }

            public Icon getIcon(boolean open) {
                return GroovyScriptClass.this.getIcon(3);
            }
        };
    }

    public PsiElement getOriginalElement() {
        return JavaPsiImplementationHelper.getInstance((Project)this.getProject()).getOriginalClass((PsiClass)this);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getIcon(int flags) {
        Icon icon = this.myFile.getIcon(flags);
        RowIcon baseIcon = ElementBase.createLayeredIcon((Iconable)this, (Icon)icon, (int)0);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }

    public void checkDelete() throws IncorrectOperationException {
    }

    public void delete() throws IncorrectOperationException {
        this.myFile.delete();
    }
}

