/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyElementPattern;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyNamedArgumentPattern
extends GroovyElementPattern<GrNamedArgument, GroovyNamedArgumentPattern> {
    public GroovyNamedArgumentPattern() {
        super(GrNamedArgument.class);
    }

    public GroovyNamedArgumentPattern withLabel(final String label) {
        return (GroovyNamedArgumentPattern)this.with((PatternCondition)new PatternCondition<GrNamedArgument>("left"){

            public boolean accepts(GrNamedArgument namedArgument, ProcessingContext context) {
                return label.equals(namedArgument.getLabelName());
            }
        });
    }

    public GroovyNamedArgumentPattern withLabel(final StringPattern labelPattern) {
        return (GroovyNamedArgumentPattern)this.with((PatternCondition)new PatternCondition<GrNamedArgument>("left"){

            public boolean accepts(GrNamedArgument namedArgument, ProcessingContext context) {
                return labelPattern.accepts((Object)namedArgument.getLabelName(), context);
            }
        });
    }

    public GroovyNamedArgumentPattern withExpression(final ElementPattern pattern) {
        return (GroovyNamedArgumentPattern)this.with((PatternCondition)new PatternCondition<GrNamedArgument>("left"){

            public boolean accepts(GrNamedArgument namedArgument, ProcessingContext context) {
                return pattern.accepts((Object)namedArgument.getExpression(), context);
            }
        });
    }

    public GroovyNamedArgumentPattern isParameterOfMethodCall(final ElementPattern<? extends GrCall> methodCall) {
        return (GroovyNamedArgumentPattern)this.with((PatternCondition)new PatternCondition<GrNamedArgument>("left"){

            public boolean accepts(GrNamedArgument namedArgument, ProcessingContext context) {
                GrCall call = PsiUtil.getCallByNamedParameter(namedArgument);
                return call != null && (methodCall == null || methodCall.accepts((Object)call, context));
            }
        });
    }
}

