/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrMethodElementType;

public class GrMethodStub
extends StubBase<GrMethod>
implements NamedStub<GrMethod> {
    public static final byte IS_DEPRECATED_BY_DOC_TAG = 1;
    private final StringRef myName;
    private final String[] myAnnotations;
    private final String[] myNamedParameters;
    private final String myTypeText;
    private final byte myFlags;

    public GrMethodStub(StubElement parent, StringRef name, String[] annotations, String[] namedParameters, GrMethodElementType elementType, String typeText, byte flags) {
        super(parent, (IStubElementType)elementType);
        this.myName = name;
        this.myAnnotations = annotations;
        this.myNamedParameters = namedParameters;
        this.myTypeText = typeText;
        this.myFlags = flags;
    }

    public String getName() {
        return StringRef.toString((StringRef)this.myName);
    }

    public String[] getAnnotations() {
        return this.myAnnotations;
    }

    public String[] getNamedParameters() {
        return this.myNamedParameters;
    }

    public String getTypeText() {
        return this.myTypeText;
    }

    public boolean isDeprecatedByDoc() {
        return (this.myFlags & 1) != 0;
    }

    public static byte buildFlags(GrMethod method) {
        byte f = 0;
        if (PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)method)) {
            f = (byte)(f | 1);
        }
        return f;
    }

    public byte getFlags() {
        return this.myFlags;
    }
}

