/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;

public class GrStubFileElementType
extends IStubFileElementType<GrFileStub> {
    public GrStubFileElementType(Language language) {
        super(language);
    }

    public StubBuilder getBuilder() {
        return new DefaultStubBuilder(){

            protected StubElement createStubForFile(PsiFile file) {
                if (file instanceof GroovyFile) {
                    return new GrFileStub((GroovyFile)file);
                }
                return super.createStubForFile(file);
            }
        };
    }

    public int getStubVersion() {
        return super.getStubVersion() + 21;
    }

    public String getExternalId() {
        return "groovy.FILE";
    }

    public void indexStub(PsiFileStub stub, IndexSink sink) {
        super.indexStub(stub, sink);
    }

    public void serialize(GrFileStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName().toString());
        dataStream.writeBoolean(stub.isScript());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
    }

    public GrFileStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        return new GrFileStub(name, isScript, GrStubUtils.readStringArray(dataStream));
    }

    public void indexStub(GrFileStub stub, IndexSink sink) {
        String name = stub.getName().toString();
        if (stub.isScript() && name != null) {
            sink.occurrence(GrScriptClassNameIndex.KEY, (Object)name);
            String pName = GrStubUtils.getPackageName(stub);
            String fqn = StringUtil.isEmpty((String)pName) ? name : pName + "." + name;
            sink.occurrence(GrFullScriptNameIndex.KEY, (Object)fqn.hashCode());
        }
        for (String anno : stub.getAnnotations()) {
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)anno);
        }
    }
}

