/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrContainerTypeConverter
extends GrTypeConverter {
    @Override
    public boolean isAllowedInMethodCall() {
        return false;
    }

    @Override
    public Boolean isConvertible(PsiType lType, PsiType rType, GroovyPsiElement context) {
        if (!GrContainerTypeConverter.isCollectionOrArray(lType) || !GrContainerTypeConverter.isCollectionOrArray(rType)) {
            return null;
        }
        PsiType lComponentType = GrContainerTypeConverter.extractComponentType(lType);
        PsiType rComponentType = GrContainerTypeConverter.extractComponentType(rType);
        if (lComponentType == null || rComponentType == null) {
            return Boolean.TRUE;
        }
        if (TypesUtil.isAssignableByMethodCallConversion(lComponentType, rComponentType, context)) {
            return Boolean.TRUE;
        }
        return null;
    }

    private static PsiType extractComponentType(PsiType type) {
        if (type instanceof PsiArrayType) {
            return ((PsiArrayType)type).getComponentType();
        }
        return PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Collection", (int)0, (boolean)false);
    }

    private static boolean isCollectionOrArray(PsiType type) {
        return type instanceof PsiArrayType || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Collection");
    }
}

