/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumConstantInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;
import org.jetbrains.plugins.groovy.lang.resolve.CollectClassMembersUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class GrClassImplUtil {
    private static final Logger LOG = Logger.getInstance(GrClassImplUtil.class);
    private static final Condition<PsiClassType> IS_GROOVY_OBJECT = new Condition<PsiClassType>(){

        public boolean value(PsiClassType psiClassType) {
            return TypesUtil.isClassType((PsiType)psiClassType, "groovy.lang.GroovyObject");
        }
    };

    private GrClassImplUtil() {
    }

    public static PsiClass findInnerClassByName(GrTypeDefinition grType, String name, boolean checkBases) {
        if (!checkBases) {
            for (PsiClass inner : grType.getInnerClasses()) {
                if (!name.equals(inner.getName())) continue;
                return inner;
            }
            return null;
        }
        Map<String, CandidateInfo> innerClasses = CollectClassMembersUtil.getAllInnerClasses(grType, true);
        CandidateInfo info = innerClasses.get(name);
        return info == null ? null : (PsiClass)info.getElement();
    }

    public static PsiClass getSuperClass(GrTypeDefinition grType) {
        PsiClassType[] extendsList = grType.getExtendsListTypes();
        if (extendsList.length == 0) {
            return GrClassImplUtil.getBaseClass(grType);
        }
        PsiClass superClass = extendsList[0].resolve();
        return superClass != null ? superClass : GrClassImplUtil.getBaseClass(grType);
    }

    public static PsiClass getBaseClass(GrTypeDefinition grType) {
        if (grType.isEnum()) {
            return JavaPsiFacade.getInstance((Project)grType.getProject()).findClass("java.lang.Enum", grType.getResolveScope());
        }
        return JavaPsiFacade.getInstance((Project)grType.getProject()).findClass("java.lang.Object", grType.getResolveScope());
    }

    public static PsiClassType[] getExtendsListTypes(GrTypeDefinition grType) {
        Object[] extendsTypes = GrClassImplUtil.getReferenceListTypes(grType.getExtendsClause());
        if (grType.isInterface()) {
            return extendsTypes;
        }
        for (PsiClassType psiClassType : extendsTypes) {
            PsiClass superClass = psiClassType.resolve();
            if ((!(superClass instanceof GrTypeDefinition) || superClass.isInterface()) && (superClass == null || !"groovy.lang.GroovyObjectSupport".equals(superClass.getQualifiedName()))) continue;
            return extendsTypes;
        }
        PsiClass grObSupport = GroovyPsiManager.getInstance(grType.getProject()).findClassWithCache("groovy.lang.GroovyObjectSupport", grType.getResolveScope());
        if (grObSupport != null) {
            PsiClassType type = JavaPsiFacade.getInstance((Project)grType.getProject()).getElementFactory().createType(grObSupport);
            return (PsiClassType[])ArrayUtil.append((Object[])extendsTypes, (Object)type, (ArrayFactory)PsiClassType.ARRAY_FACTORY);
        }
        return extendsTypes;
    }

    public static PsiClassType[] getImplementsListTypes(GrTypeDefinition grType) {
        HashSet visited = new HashSet();
        ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        GrClassImplUtil.getImplementListsInner(grType, result, (Set<PsiClass>)visited);
        return result.toArray(new PsiClassType[result.size()]);
    }

    private static void getImplementListsInner(GrTypeDefinition grType, List<PsiClassType> result, Set<PsiClass> visited) {
        if (!visited.add(grType)) {
            return;
        }
        Object[] implementsTypes = GrClassImplUtil.getReferenceListTypes(grType.getImplementsClause());
        List<PsiClassType> fromDelegates = GrClassImplUtil.getImplementsFromDelegate(grType, visited);
        if (fromDelegates != null) {
            result.addAll(fromDelegates);
        }
        result.addAll(Arrays.asList(implementsTypes));
        if (!(grType.isInterface() || ContainerUtil.or((Object[])implementsTypes, IS_GROOVY_OBJECT) || ContainerUtil.or((Object[])GrClassImplUtil.getReferenceListTypes(grType.getExtendsClause()), IS_GROOVY_OBJECT))) {
            result.add(GrClassImplUtil.getGroovyObjectType(grType));
        }
    }

    private static List<PsiClassType> getImplementsFromDelegate(final GrTypeDefinition grType, final Set<PsiClass> visited) {
        return (List)RecursionManager.doPreventingRecursion((Object)grType, (boolean)true, (Computable)new Computable<List<PsiClassType>>(){

            public List<PsiClassType> compute() {
                GrField[] fields;
                ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
                for (GrField field : fields = grType.getCodeFields()) {
                    PsiClass psiClass;
                    PsiType type;
                    boolean shouldImplement;
                    PsiAnnotation delegate = PsiImplUtil.getAnnotation((PsiModifierListOwner)field, "groovy.lang.Delegate");
                    if (delegate == null || !(shouldImplement = GrClassImplUtil.shouldImplementDelegatedInterfaces(delegate)) || !((type = field.getDeclaredType()) instanceof PsiClassType) || (psiClass = ((PsiClassType)type).resolve()) == null) continue;
                    if (psiClass instanceof GrTypeDefinition) {
                        GrClassImplUtil.getImplementListsInner((GrTypeDefinition)psiClass, result, visited);
                    } else {
                        result.addAll(Arrays.asList(psiClass.getImplementsListTypes()));
                    }
                    if (!psiClass.isInterface()) continue;
                    result.add((PsiClassType)type);
                }
                return result;
            }
        });
    }

    public static PsiClassType getGroovyObjectType(PsiElement context) {
        return TypesUtil.createTypeByFQClassName("groovy.lang.GroovyObject", context);
    }

    public static PsiClassType[] getSuperTypes(GrTypeDefinition grType) {
        Object[] extendsList = grType.getExtendsListTypes();
        if (extendsList.length == 0) {
            extendsList = new PsiClassType[]{GrClassImplUtil.createBaseClassType(grType)};
        }
        return (PsiClassType[])ArrayUtil.mergeArrays((Object[])extendsList, (Object[])grType.getImplementsListTypes(), (ArrayFactory)PsiClassType.ARRAY_FACTORY);
    }

    public static PsiClassType createBaseClassType(GrTypeDefinition grType) {
        if (grType.isEnum()) {
            return TypesUtil.createTypeByFQClassName("java.lang.Enum", grType);
        }
        return TypesUtil.getJavaLangObject(grType);
    }

    public static PsiMethod[] getAllMethods(final GrTypeDefinition grType) {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)grType, (CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            public CachedValueProvider.Result<PsiMethod[]> compute() {
                ArrayList list = ContainerUtil.newArrayList();
                GrClassImplUtil.getAllMethodsInner(grType, list, (HashSet<PsiClass>)new HashSet());
                return CachedValueProvider.Result.create((Object)list.toArray(new PsiMethod[list.size()]), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, grType});
            }
        });
    }

    public static List<PsiMethod> getAllMethods(Collection<? extends PsiClass> classes) {
        ArrayList<PsiMethod> allMethods = new ArrayList<PsiMethod>();
        HashSet visited = new HashSet();
        for (PsiClass psiClass : classes) {
            GrClassImplUtil.getAllMethodsInner(psiClass, allMethods, (HashSet<PsiClass>)visited);
        }
        return allMethods;
    }

    private static void getAllMethodsInner(PsiClass clazz, List<PsiMethod> allMethods, HashSet<PsiClass> visited) {
        PsiClass[] supers;
        if (visited.contains((Object)clazz)) {
            return;
        }
        visited.add((Object)clazz);
        ContainerUtil.addAll(allMethods, (Object[])clazz.getMethods());
        for (PsiClass aSuper : supers = clazz.getSupers()) {
            GrClassImplUtil.getAllMethodsInner(aSuper, allMethods, visited);
        }
    }

    private static PsiClassType[] getReferenceListTypes(GrReferenceList list) {
        if (list == null) {
            return PsiClassType.EMPTY_ARRAY;
        }
        return list.getReferencedTypes();
    }

    public static PsiClass[] getInterfaces(GrTypeDefinition grType) {
        PsiClassType[] implementsListTypes = grType.getImplementsListTypes();
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(implementsListTypes.length);
        for (PsiClassType type : implementsListTypes) {
            PsiClass psiClass = type.resolve();
            if (psiClass == null) continue;
            result.add(psiClass);
        }
        return result.toArray(new PsiClass[result.size()]);
    }

    public static PsiClass[] getSupers(GrTypeDefinition grType) {
        PsiClassType[] superTypes = grType.getSuperTypes();
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (PsiClassType superType : superTypes) {
            PsiClass superClass = superType.resolve();
            if (superClass == null) continue;
            result.add(superClass);
        }
        return result.toArray(new PsiClass[result.size()]);
    }

    public static boolean processDeclarations(GrTypeDefinition grType, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        GrTypeDefinitionBody body;
        PsiElement possibleAnnotation;
        if (place instanceof GrCodeReferenceElement && lastParent instanceof GrModifierList && (possibleAnnotation = PsiTreeUtil.skipParentsOfType((PsiElement)place, (Class[])new Class[]{GrCodeReferenceElement.class})) instanceof GrAnnotation && possibleAnnotation.getParent() == lastParent) {
            return true;
        }
        for (PsiTypeParameter typeParameter : grType.getTypeParameters()) {
            if (ResolveUtil.processElement(processor, (PsiNamedElement)typeParameter, state)) continue;
            return false;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String name = nameHint == null ? null : nameHint.getName(state);
        ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        boolean processInstanceMethods = (ResolveUtil.shouldProcessMethods(classHint) || ResolveUtil.shouldProcessProperties(classHint)) && GrClassImplUtil.shouldProcessInstanceMembers(grType, lastParent);
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)place);
        if (ResolveUtil.shouldProcessProperties(classHint)) {
            Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType);
            if (name != null) {
                PsiField field;
                CandidateInfo fieldInfo = fieldsMap.get(name);
                if (fieldInfo != null ? !GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, fieldInfo) : grType.isTrait() && lastParent != null && (field = GrClassImplUtil.findFieldByName(grType, name, false, true)) != null && field.hasModifierProperty("public") && !GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, new CandidateInfo((PsiElement)field, PsiSubstitutor.EMPTY))) {
                    return false;
                }
            } else {
                for (CandidateInfo info : fieldsMap.values()) {
                    if (GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, info)) continue;
                    return false;
                }
                if (grType.isTrait() && lastParent != null) {
                    for (PsiField field : CollectClassMembersUtil.getFields(grType, true)) {
                        if (!field.hasModifierProperty("public") || GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, new CandidateInfo((PsiElement)field, PsiSubstitutor.EMPTY))) continue;
                        return false;
                    }
                }
            }
        }
        if (ResolveUtil.shouldProcessMethods(classHint)) {
            boolean isPlaceGroovy;
            Map<String, List<CandidateInfo>> methodsMap = CollectClassMembersUtil.getAllMethods(grType, true);
            boolean bl = isPlaceGroovy = place.getLanguage() == GroovyLanguage.INSTANCE;
            if (name == null) {
                for (List<CandidateInfo> list : methodsMap.values()) {
                    for (CandidateInfo info : list) {
                        if (GrClassImplUtil.processMethod(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, isPlaceGroovy, info)) continue;
                        return false;
                    }
                }
            } else {
                List<CandidateInfo> byName = methodsMap.get(name);
                if (byName != null) {
                    for (CandidateInfo info : byName) {
                        if (GrClassImplUtil.processMethod(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, isPlaceGroovy, info)) continue;
                        return false;
                    }
                }
            }
        }
        if ((body = grType.getBody()) != null && ResolveUtil.shouldProcessClasses(classHint)) {
            for (PsiClass innerClass : GrClassImplUtil.getInnerClassesForResolve(grType, lastParent, place)) {
                String innerClassName = innerClass.getName();
                if (nameHint != null && !innerClassName.equals(nameHint.getName(state)) || processor.execute((PsiElement)innerClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processField(GrTypeDefinition grType, PsiScopeProcessor processor, ResolveState state, PsiElement place, boolean processInstanceMethods, PsiSubstitutor substitutor, PsiElementFactory factory, LanguageLevel level, CandidateInfo fieldInfo) {
        PsiField field = (PsiField)fieldInfo.getElement();
        if (!GrClassImplUtil.processInstanceMember(processInstanceMethods, (PsiMember)field) || GrClassImplUtil.isSameDeclaration(place, (PsiElement)field)) {
            return true;
        }
        LOG.assertTrue(field.getContainingClass() != null);
        PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)field.getContainingClass(), (PsiSubstitutor)fieldInfo.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor, (PsiElementFactory)factory, (LanguageLevel)level);
        return processor.execute((PsiElement)field, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor));
    }

    private static boolean processMethod(GrTypeDefinition grType, PsiScopeProcessor processor, ResolveState state, PsiElement place, boolean processInstanceMethods, PsiSubstitutor substitutor, PsiElementFactory factory, LanguageLevel level, boolean placeGroovy, CandidateInfo info) {
        PsiMethod method = (PsiMethod)info.getElement();
        if (!GrClassImplUtil.processInstanceMember(processInstanceMethods, (PsiMember)method) || GrClassImplUtil.isSameDeclaration(place, (PsiElement)method) || !GrClassImplUtil.isMethodVisible(placeGroovy, method)) {
            return true;
        }
        LOG.assertTrue(method.getContainingClass() != null);
        PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)method.getContainingClass(), (PsiSubstitutor)info.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor, (PsiElementFactory)factory, (LanguageLevel)level);
        return processor.execute((PsiElement)method, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor));
    }

    private static boolean shouldProcessInstanceMembers(GrTypeDefinition grType, PsiElement lastParent) {
        GrModifierList modifierList;
        return lastParent == null || (modifierList = grType.getModifierList()) == null || modifierList.findAnnotation("groovy.lang.Category") == null;
    }

    private static boolean processInstanceMember(boolean shouldProcessInstance, PsiMember member) {
        if (shouldProcessInstance) {
            return true;
        }
        if (member instanceof GrReflectedMethod) {
            return ((GrReflectedMethod)member).getBaseMethod().hasModifierProperty("static");
        }
        return member.hasModifierProperty("static");
    }

    private static List<PsiClass> getInnerClassesForResolve(final GrTypeDefinition grType, final PsiElement lastParent, final PsiElement place) {
        if (lastParent instanceof GrReferenceList || PsiTreeUtil.getParentOfType((PsiElement)place, GrReferenceList.class) != null) {
            return Arrays.asList(grType.getInnerClasses());
        }
        List classes = (List)RecursionManager.doPreventingRecursion((Object)grType, (boolean)true, (Computable)new Computable<List<PsiClass>>(){

            public List<PsiClass> compute() {
                ArrayList<PsiClass> result = new ArrayList<PsiClass>();
                for (CandidateInfo info : CollectClassMembersUtil.getAllInnerClasses(grType, false).values()) {
                    PsiClass inner = (PsiClass)info.getElement();
                    PsiClass containingClass = inner.getContainingClass();
                    assert (containingClass != null);
                    if (lastParent != null && containingClass.isInterface() && !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)place, (boolean)false)) continue;
                    ContainerUtil.addIfNotNull(result, (Object)inner);
                }
                return result;
            }
        });
        if (classes == null) {
            return Arrays.asList(grType.getInnerClasses());
        }
        return classes;
    }

    public static boolean isSameDeclaration(PsiElement place, PsiElement element) {
        if (element instanceof GrAccessorMethod) {
            element = ((GrAccessorMethod)element).getProperty();
        }
        if (!(element instanceof GrField)) {
            return false;
        }
        if (element instanceof GrScriptField) {
            element = ((GrScriptField)element).getOriginalVariable();
        }
        while (place != null) {
            if (place == element) {
                return true;
            }
            if ((place = place.getParent()) instanceof GrClosableBlock) {
                return false;
            }
            if (!(place instanceof GrEnumConstantInitializer)) continue;
            return false;
        }
        return false;
    }

    private static boolean isMethodVisible(boolean isPlaceGroovy, PsiMethod method) {
        return isPlaceGroovy || !(method instanceof GrGdkMethod);
    }

    public static PsiMethod findMethodBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : GrClassImplUtil.findMethodsByName(grType, patternMethod.getName(), checkBases, false)) {
            MethodSignature signature = GrClassImplUtil.getSignatureForInheritor(method, grType);
            if (!patternSignature.equals(signature)) continue;
            return method;
        }
        return null;
    }

    private static PsiMethod[] findMethodsByName(GrTypeDefinition grType, String name, boolean checkBases, boolean includeSyntheticAccessors) {
        if (!checkBases) {
            ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
            for (PsiMethod method : CollectClassMembersUtil.getMethods(grType, includeSyntheticAccessors)) {
                if (!name.equals(method.getName())) continue;
                result.add(method);
            }
            return result.toArray(new PsiMethod[result.size()]);
        }
        Map<String, List<CandidateInfo>> methodsMap = CollectClassMembersUtil.getAllMethods(grType, includeSyntheticAccessors);
        return PsiImplUtil.mapToMethods(methodsMap.get(name));
    }

    public static PsiMethod[] findMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodsBySignature(grType, patternMethod, checkBases, true);
    }

    public static PsiMethod[] findCodeMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodsBySignature(grType, patternMethod, checkBases, false);
    }

    public static PsiMethod[] findMethodsByName(GrTypeDefinition grType, @NonNls String name, boolean checkBases) {
        return GrClassImplUtil.findMethodsByName(grType, name, checkBases, true);
    }

    private static PsiMethod[] findMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases, boolean includeSynthetic) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : GrClassImplUtil.findMethodsByName(grType, patternMethod.getName(), checkBases, includeSynthetic)) {
            MethodSignature signature = GrClassImplUtil.getSignatureForInheritor(method, grType);
            if (!patternSignature.equals(signature)) continue;
            result.add(method);
        }
        return result.toArray(new PsiMethod[result.size()]);
    }

    private static MethodSignature getSignatureForInheritor(PsiMethod methodFromSuperClass, GrTypeDefinition inheritor) {
        PsiClass clazz = methodFromSuperClass.getContainingClass();
        if (clazz == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)clazz, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return null;
        }
        return methodFromSuperClass.getSignature(superSubstitutor);
    }

    public static PsiMethod[] findCodeMethodsByName(GrTypeDefinition grType, @NonNls String name, boolean checkBases) {
        return GrClassImplUtil.findMethodsByName(grType, name, checkBases, false);
    }

    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(GrTypeDefinition grType, String name, boolean checkBases) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result;
        block3: {
            block2: {
                PsiMethod[] methods;
                result = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
                if (checkBases) break block2;
                for (PsiMethod method : methods = grType.findMethodsByName(name, false)) {
                    result.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)method, (Object)PsiSubstitutor.EMPTY));
                }
                break block3;
            }
            Map<String, List<CandidateInfo>> map = CollectClassMembersUtil.getAllMethods(grType, true);
            List<CandidateInfo> candidateInfos = map.get(name);
            if (candidateInfos == null) break block3;
            for (CandidateInfo info : candidateInfos) {
                PsiElement element = info.getElement();
                result.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)element), (Object)info.getSubstitutor()));
            }
        }
        return result;
    }

    public static List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors(GrTypeDefinition grType) {
        Map<String, List<CandidateInfo>> allMethodsMap = CollectClassMembersUtil.getAllMethods(grType, true);
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (List<CandidateInfo> infos : allMethodsMap.values()) {
            for (CandidateInfo info : infos) {
                result.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)info.getElement()), (Object)info.getSubstitutor()));
            }
        }
        return result;
    }

    public static PsiField findFieldByName(GrTypeDefinition grType, String name, boolean checkBases, boolean includeSynthetic) {
        if (!checkBases) {
            for (PsiField field : CollectClassMembersUtil.getFields(grType, includeSynthetic)) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
            return null;
        }
        Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType, includeSynthetic);
        CandidateInfo info = fieldsMap.get(name);
        return info == null ? null : (PsiField)info.getElement();
    }

    public static PsiField[] getAllFields(GrTypeDefinition grType) {
        Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType);
        return (PsiField[])ContainerUtil.map2Array(fieldsMap.values(), PsiField.class, (Function)new Function<CandidateInfo, PsiField>(){

            public PsiField fun(CandidateInfo entry) {
                return (PsiField)entry.getElement();
            }
        });
    }

    public static boolean isClassEquivalentTo(GrTypeDefinitionImpl definition, PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo((PsiClass)definition, (PsiElement)another);
    }

    private static boolean shouldImplementDelegatedInterfaces(PsiAnnotation delegate) {
        Boolean result = GrAnnotationUtil.inferBooleanAttribute(delegate, "interfaces");
        return result == null || result != false;
    }

    public static void addExpandingReflectedMethods(List<PsiMethod> result, PsiMethod method) {
        GrReflectedMethod[] reflectedMethods;
        if (method instanceof GrMethod && (reflectedMethods = ((GrMethod)method).getReflectedMethods()).length > 0) {
            result.addAll(Arrays.asList(reflectedMethods));
            return;
        }
        result.add(method);
    }

    public static void collectMethodsFromBody(GrTypeDefinition definition, List<PsiMethod> result) {
        for (GrMethod grMethod : definition.getCodeMethods()) {
            GrClassImplUtil.addExpandingReflectedMethods(result, grMethod);
        }
        for (GrDocCommentOwner grDocCommentOwner : definition.getFields()) {
            if (!grDocCommentOwner.isProperty()) continue;
            ContainerUtil.addAll(result, (Object[])grDocCommentOwner.getGetters());
            ContainerUtil.addIfNotNull(result, (Object)grDocCommentOwner.getSetter());
        }
    }
}

