/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyImportHelper;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;

public class GroovyImportUtil {
    public static void processFile(final PsiFile file, final Set<String> importedClasses, final Set<String> staticallyImportedMembers, final Set<GrImportStatement> usedImports, Set<GrImportStatement> unresolvedOnDemandImports, final Set<String> implicitlyImported, final Set<String> innerClasses, final Map<String, String> aliased, final Map<String, String> annotations) {
        if (!(file instanceof GroovyFile)) {
            return;
        }
        final LinkedHashSet unresolvedReferenceNames = ContainerUtil.newLinkedHashSet();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (element instanceof GrReferenceElement) {
                    this.visitRefElement((GrReferenceElement)element);
                }
            }

            private void visitRefElement(GrReferenceElement refElement) {
                String refName = refElement.getReferenceName();
                if ("super".equals(refName)) {
                    return;
                }
                GroovyResolveResult[] resolveResults = refElement.multiResolve(false);
                if (resolveResults.length == 0 && refName != null && PsiTreeUtil.getParentOfType((PsiElement)refElement, GrImportStatement.class) == null) {
                    unresolvedReferenceNames.add(refName);
                }
                for (GroovyResolveResult resolveResult : resolveResults) {
                    PsiElement context = resolveResult.getCurrentFileResolveContext();
                    PsiElement resolved = resolveResult.getElement();
                    if (resolved == null) {
                        return;
                    }
                    if (context instanceof GrImportStatement) {
                        GrImportStatement importStatement = (GrImportStatement)context;
                        if (usedImports != null && this.isImportUsed(refElement, resolved)) {
                            usedImports.add(importStatement);
                        }
                        if (GroovyImportHelper.isImplicitlyImported(resolved, refName, (GroovyFile)file)) {
                            this.addImplicitClass(resolved);
                        }
                        if (importStatement.isAliasedImport() || GroovyImportUtil.isAnnotatedImport(importStatement)) continue;
                        String importedName = null;
                        if (importStatement.isOnDemand()) {
                            if (importStatement.isStatic()) {
                                String name;
                                String classQName;
                                PsiMember member;
                                PsiClass clazz;
                                if (resolved instanceof PsiMember && (clazz = (member = (PsiMember)resolved).getContainingClass()) != null && (classQName = clazz.getQualifiedName()) != null && (name = member.getName()) != null) {
                                    importedName = classQName + "." + name;
                                }
                            } else {
                                importedName = GroovyImportUtil.getTargetQualifiedName(resolved);
                            }
                        } else {
                            GrCodeReferenceElement importReference = importStatement.getImportReference();
                            if (importReference != null) {
                                importedName = PsiUtil.getQualifiedReferenceText(importReference);
                            }
                        }
                        if (importedName == null) {
                            return;
                        }
                        String importRef = GroovyImportUtil.getImportReferenceText(importStatement);
                        if (importStatement.isAliasedImport()) {
                            if (aliased != null) {
                                aliased.put(importRef, importedName);
                            }
                            return;
                        }
                        if (importStatement.isStatic()) {
                            if (staticallyImportedMembers == null) continue;
                            staticallyImportedMembers.add(importedName);
                            continue;
                        }
                        if (importedClasses != null) {
                            importedClasses.add(importedName);
                        }
                        if (!(resolved instanceof PsiClass) || ((PsiClass)resolved).getContainingClass() == null || innerClasses == null) continue;
                        innerClasses.add(importedName);
                        continue;
                    }
                    if (context != null || refElement.getParent() instanceof GrImportStatement || refElement.getQualifier() != null) continue;
                    this.addImplicitClass(resolved);
                }
            }

            private void addImplicitClass(PsiElement element) {
                String qname = GroovyImportUtil.getTargetQualifiedName(element);
                if (qname != null) {
                    if (implicitlyImported != null) {
                        implicitlyImported.add(qname);
                    }
                    if (importedClasses != null) {
                        importedClasses.add(qname);
                    }
                }
            }

            private boolean isImportUsed(GrReferenceElement refElement, PsiElement resolved) {
                if (GroovyImportHelper.isImplicitlyImported(resolved, refElement.getReferenceName(), (GroovyFile)file)) {
                    ClassResolverProcessor processor = new ClassResolverProcessor(refElement.getReferenceName(), refElement, ClassHint.RESOLVE_KINDS_CLASS);
                    GroovyImportHelper.processImports(ResolveState.initial(), null, refElement, processor, ((GroovyFile)file).getImportStatements(), true);
                    if (!processor.hasCandidates()) {
                        return false;
                    }
                }
                return true;
            }
        });
        LinkedHashSet importsToCheck = ContainerUtil.newLinkedHashSet(PsiUtil.getValidImportStatements((GroovyFile)file));
        for (GrImportStatement anImport : importsToCheck) {
            if (usedImports != null && usedImports.contains(anImport)) continue;
            GrCodeReferenceElement ref = anImport.getImportReference();
            assert (ref != null) : "invalid import!";
            if (ref.resolve() != null) continue;
            if (anImport.isOnDemand()) {
                if (usedImports != null) {
                    usedImports.add(anImport);
                }
                if (unresolvedOnDemandImports == null) continue;
                unresolvedOnDemandImports.add(anImport);
                continue;
            }
            String importedName = anImport.getImportedName();
            if (importedName == null || !unresolvedReferenceNames.contains(importedName)) continue;
            if (usedImports != null) {
                usedImports.add(anImport);
            }
            String symbolName = GroovyImportUtil.getImportReferenceText(anImport);
            if (anImport.isAliasedImport()) {
                if (aliased == null) continue;
                aliased.put(symbolName, importedName);
                continue;
            }
            if (anImport.isStatic()) {
                if (staticallyImportedMembers == null) continue;
                staticallyImportedMembers.add(symbolName);
                continue;
            }
            if (importedClasses == null) continue;
            importedClasses.add(symbolName);
        }
        if (annotations != null) {
            ((GroovyFile)file).acceptChildren(new GroovyElementVisitor(){

                @Override
                public void visitImportStatement(GrImportStatement importStatement) {
                    String annotationText = importStatement.getAnnotationList().getText();
                    if (!StringUtil.isEmptyOrSpaces((String)annotationText)) {
                        String importRef = GroovyImportUtil.getImportReferenceText(importStatement);
                        annotations.put(importRef, annotationText);
                    }
                }
            });
        }
    }

    private static String getTargetQualifiedName(PsiElement element) {
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            return ((PsiMethod)element).getContainingClass().getQualifiedName();
        }
        return null;
    }

    public static boolean isAnnotatedImport(GrImportStatement anImport) {
        return !StringUtil.isEmptyOrSpaces((String)anImport.getAnnotationList().getText());
    }

    public static String getImportReferenceText(GrImportStatement statement) {
        GrCodeReferenceElement importReference = statement.getImportReference();
        if (importReference != null) {
            return importReference.getClassNameText();
        }
        return null;
    }

    public static Set<GrImportStatement> findUsedImports(GroovyFile file) {
        HashSet usedImports = new HashSet();
        GroovyImportUtil.processFile(file, null, null, (Set<GrImportStatement>)usedImports, null, null, null, null, null);
        return usedImports;
    }
}

