/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class CollectClassMembersUtil {
    private static final Key<CachedValue<ClassMembers>> CACHED_MEMBERS = Key.create((String)"CACHED_CLASS_MEMBERS");
    private static final Key<CachedValue<ClassMembers>> CACHED_MEMBERS_INCLUDING_SYNTHETIC = Key.create((String)"CACHED_MEMBERS_INCLUDING_SYNTHETIC");

    private CollectClassMembersUtil() {
    }

    public static Map<String, List<CandidateInfo>> getAllMethods(PsiClass aClass, boolean includeSynthetic) {
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getMethods();
    }

    private static ClassMembers getCachedMembers(PsiClass aClass, boolean includeSynthetic) {
        PsiUtilCore.ensureValid((PsiElement)aClass);
        Key<CachedValue<ClassMembers>> key = includeSynthetic ? CACHED_MEMBERS_INCLUDING_SYNTHETIC : CACHED_MEMBERS;
        CachedValue<ClassMembers> cachedValue = (CachedValue<ClassMembers>)aClass.getUserData(key);
        if (CollectClassMembersUtil.isCyclicDependence(aClass)) {
            includeSynthetic = false;
        }
        if (cachedValue == null) {
            cachedValue = CollectClassMembersUtil.buildCache(aClass, includeSynthetic);
            aClass.putUserData(key, cachedValue);
        }
        return (ClassMembers)cachedValue.getValue();
    }

    private static boolean isCyclicDependence(PsiClass aClass) {
        return !CollectClassMembersUtil.processCyclicDependence(aClass, ContainerUtil.newHashSet());
    }

    private static boolean processCyclicDependence(PsiClass aClass, Set<PsiClass> classes) {
        if (!classes.add(aClass)) {
            return aClass.isInterface() || "java.lang.Object".equals(aClass.getQualifiedName());
        }
        if (aClass instanceof ClsClassImpl) {
            return true;
        }
        for (PsiClass psiClass : aClass.getSupers()) {
            if (CollectClassMembersUtil.processCyclicDependence(psiClass, classes)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, CandidateInfo> getAllInnerClasses(PsiClass aClass, boolean includeSynthetic) {
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getInnerClasses();
    }

    public static Map<String, CandidateInfo> getAllFields(PsiClass aClass, boolean includeSynthetic) {
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getFields();
    }

    public static Map<String, CandidateInfo> getAllFields(PsiClass aClass) {
        return CollectClassMembersUtil.getAllFields(aClass, true);
    }

    private static CachedValue<ClassMembers> buildCache(final PsiClass aClass, final boolean includeSynthetic) {
        return CachedValuesManager.getManager((Project)aClass.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<ClassMembers>(){

            public CachedValueProvider.Result<ClassMembers> compute() {
                LinkedHashMap allFields = ContainerUtil.newLinkedHashMap();
                LinkedHashMap allMethods = ContainerUtil.newLinkedHashMap();
                LinkedHashMap allInnerClasses = ContainerUtil.newLinkedHashMap();
                CollectClassMembersUtil.processClass(aClass, allFields, allMethods, allInnerClasses, (Set)new HashSet(), PsiSubstitutor.EMPTY, includeSynthetic);
                return CachedValueProvider.Result.create((Object)ClassMembers.create(allFields, allMethods, allInnerClasses), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        }, false);
    }

    private static void processClass(PsiClass aClass, Map<String, CandidateInfo> allFields, Map<String, List<CandidateInfo>> allMethods, Map<String, CandidateInfo> allInnerClasses, Set<PsiClass> visitedClasses, PsiSubstitutor substitutor, boolean includeSynthetic) {
        String name;
        PsiUtilCore.ensureValid((PsiElement)aClass);
        if (!visitedClasses.add(aClass)) {
            return;
        }
        if (visitedClasses.size() == 1 || !GrTraitUtil.isTrait(aClass)) {
            for (PsiField psiField : CollectClassMembersUtil.getFields(aClass, includeSynthetic)) {
                GrModifierList modifierList;
                CandidateInfo candidateInfo;
                PsiElement element;
                name = psiField.getName();
                if (!allFields.containsKey(name)) {
                    allFields.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
                    continue;
                }
                if (!CollectClassMembersUtil.hasExplicitVisibilityModifiers(psiField) || !((element = (candidateInfo = allFields.get(name)).getElement()) instanceof GrField) || (modifierList = ((GrField)element).getModifierList()) != null && modifierList.hasExplicitVisibilityModifiers() || aClass != ((GrField)element).getContainingClass()) continue;
                allFields.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
            }
        }
        for (PsiField psiField : CollectClassMembersUtil.getMethods(aClass, includeSynthetic)) {
            CollectClassMembersUtil.addMethod(allMethods, (PsiMethod)psiField, substitutor);
        }
        for (PsiField psiField : aClass.getInnerClasses()) {
            name = psiField.getName();
            if (name == null || allInnerClasses.containsKey(name)) continue;
            allInnerClasses.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
        }
        for (PsiField psiField : aClass.getSuperTypes()) {
            PsiClass superClass = psiField.resolve();
            if (superClass == null) continue;
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)substitutor);
            CollectClassMembersUtil.processClass(superClass, allFields, allMethods, allInnerClasses, visitedClasses, superSubstitutor, includeSynthetic);
        }
    }

    public static PsiField[] getFields(PsiClass aClass, boolean includeSynthetic) {
        return includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getFields() : ((GrTypeDefinition)aClass).getCodeFields();
    }

    public static PsiMethod[] getMethods(PsiClass aClass, boolean includeSynthetic) {
        return includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getMethods() : ((GrTypeDefinition)aClass).getCodeMethods();
    }

    private static boolean hasExplicitVisibilityModifiers(PsiField field) {
        if (field instanceof GrField) {
            GrModifierList list = (GrModifierList)field.getModifierList();
            return list == null || list.hasExplicitVisibilityModifiers();
        }
        return true;
    }

    private static void addMethod(Map<String, List<CandidateInfo>> allMethods, PsiMethod method, PsiSubstitutor substitutor) {
        String name = method.getName();
        List<CandidateInfo> methods = allMethods.get(name);
        if (methods == null) {
            methods = new ArrayList<CandidateInfo>();
            allMethods.put(name, methods);
        }
        methods.add(new CandidateInfo((PsiElement)method, substitutor));
    }

    private static class ClassMembers {
        private final Map<String, CandidateInfo> myFields;
        private final Map<String, List<CandidateInfo>> myMethods;
        private final Map<String, CandidateInfo> myInnerClasses;

        private ClassMembers(Map<String, CandidateInfo> fields, Map<String, List<CandidateInfo>> methods, Map<String, CandidateInfo> innerClasses) {
            this.myFields = fields;
            this.myMethods = methods;
            this.myInnerClasses = innerClasses;
        }

        public static ClassMembers create(LinkedHashMap<String, CandidateInfo> first, LinkedHashMap<String, List<CandidateInfo>> second, LinkedHashMap<String, CandidateInfo> third) {
            return new ClassMembers(first, second, third);
        }

        private Map<String, CandidateInfo> getFields() {
            return this.myFields;
        }

        private Map<String, List<CandidateInfo>> getMethods() {
            return this.myMethods;
        }

        private Map<String, CandidateInfo> getInnerClasses() {
            return this.myInnerClasses;
        }
    }
}

