/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.Key;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.EnumSet;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public abstract class GrScopeProcessorWithHints
implements PsiScopeProcessor,
NameHint,
ClassHint,
ElementClassHint {
    protected final EnumSet<ClassHint.ResolveKind> myResolveTargetKinds;
    protected final String myName;

    public GrScopeProcessorWithHints(String name, EnumSet<ClassHint.ResolveKind> resolveTargets) {
        this.myName = name;
        this.myResolveTargetKinds = resolveTargets;
    }

    public <T> T getHint(Key<T> hintKey) {
        if (NameHint.KEY == hintKey && this.myName != null) {
            return (T)this;
        }
        if ((ClassHint.KEY == hintKey || ElementClassHint.KEY == hintKey) && this.myResolveTargetKinds != null) {
            return (T)this;
        }
        return null;
    }

    @Override
    public boolean shouldProcess(ClassHint.ResolveKind resolveKind) {
        assert (this.myResolveTargetKinds != null) : "don't invoke shouldProcess if resolveTargets are not declared";
        return this.myResolveTargetKinds.contains((Object)resolveKind);
    }

    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        switch (kind) {
            case CLASS: {
                return this.shouldProcess(ClassHint.ResolveKind.CLASS);
            }
            case ENUM_CONST: 
            case VARIABLE: 
            case FIELD: {
                return this.shouldProcess(ClassHint.ResolveKind.PROPERTY);
            }
            case METHOD: {
                return this.shouldProcess(ClassHint.ResolveKind.METHOD);
            }
            case PACKAGE: {
                return this.shouldProcess(ClassHint.ResolveKind.PACKAGE);
            }
        }
        return false;
    }

    public String getName(ResolveState state) {
        return this.myName;
    }

    public String getName() {
        return this.myName;
    }

    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
    }
}

