/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.tree.java.PsiLocalVariableImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;

public class ResolverProcessor
extends GrScopeProcessorWithHints {
    private Set<String> myProcessedClasses;
    protected final PsiElement myPlace;
    private final PsiType[] myTypeArguments;
    private List<GroovyResolveResult> myCandidates;

    protected ResolverProcessor(String name, EnumSet<ClassHint.ResolveKind> resolveTargets, PsiElement place, PsiType[] typeArguments) {
        super(name, resolveTargets);
        this.myPlace = place;
        this.myTypeArguments = typeArguments;
    }

    public boolean execute(PsiElement element, ResolveState state) {
        if (element instanceof PsiLocalVariableImpl) {
            return true;
        }
        if (this.myResolveTargetKinds.contains((Object)ResolverProcessor.getResolveKind(element))) {
            if (element instanceof PsiVariable && !(element instanceof PsiField) && this.getName() != null && !this.getName().equals(((PsiVariable)element).getName())) {
                return true;
            }
            PsiNamedElement namedElement = (PsiNamedElement)element;
            PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
            if (substitutor == null) {
                substitutor = PsiSubstitutor.EMPTY;
            }
            if (this.myTypeArguments.length > 0 && namedElement instanceof PsiClass) {
                substitutor = substitutor.putAll((PsiClass)namedElement, this.myTypeArguments);
            }
            if (namedElement instanceof PsiClass && !(namedElement instanceof PsiTypeParameter)) {
                PsiClass aClass = (PsiClass)namedElement;
                if (this.myProcessedClasses == null) {
                    this.myProcessedClasses = new HashSet<String>();
                }
                if (!this.myProcessedClasses.add(aClass.getQualifiedName())) {
                    return true;
                }
            }
            boolean isAccessible = this.isAccessible(namedElement);
            PsiElement resolveContext = (PsiElement)state.get(RESOLVE_CONTEXT);
            SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
            boolean isStaticsOK = this.isStaticsOK(namedElement, resolveContext, false);
            this.addCandidate(new GroovyResolveResultImpl((PsiElement)namedElement, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK));
            return !isAccessible || !isStaticsOK;
        }
        return true;
    }

    protected final void addCandidate(GroovyResolveResult candidate) {
        PsiElement element = candidate.getElement();
        assert (element == null || element.isValid()) : ResolverProcessor.getElementInfo(element);
        if (this.myCandidates == null) {
            this.myCandidates = new ArrayList<GroovyResolveResult>();
        }
        this.myCandidates.add(candidate);
    }

    private static String getElementInfo(PsiElement element) {
        PsiElement context;
        String text = element instanceof LightElement ? ((context = element.getContext()) instanceof LightElement ? context.toString() : (context != null ? context.getText() : null)) : element.getText();
        return "invalid resolve candidate: " + element.getClass() + ", text: " + text;
    }

    protected List<GroovyResolveResult> getCandidatesInternal() {
        return this.myCandidates == null ? Collections.emptyList() : this.myCandidates;
    }

    protected boolean isAccessible(PsiNamedElement namedElement) {
        if (namedElement instanceof GrField) {
            GrField field = (GrField)namedElement;
            if (PsiUtil.isAccessible(this.myPlace, field)) {
                return true;
            }
            for (GrAccessorMethod method : field.getGetters()) {
                if (!PsiUtil.isAccessible(this.myPlace, (PsiMember)method)) continue;
                return true;
            }
            GrAccessorMethod setter = field.getSetter();
            return setter != null && PsiUtil.isAccessible(this.myPlace, (PsiMember)setter);
        }
        return !(namedElement instanceof PsiMember) || PsiUtil.isAccessible(this.myPlace, (PsiMember)namedElement);
    }

    protected boolean isStaticsOK(PsiNamedElement element, PsiElement resolveContext, boolean filterStaticAfterInstanceQualifier) {
        if (resolveContext instanceof GrImportStatement) {
            return true;
        }
        if (element instanceof PsiModifierListOwner) {
            return GrStaticChecker.isStaticsOK((PsiModifierListOwner)element, this.myPlace, resolveContext, filterStaticAfterInstanceQualifier);
        }
        return true;
    }

    public GroovyResolveResult[] getCandidates() {
        if (this.myCandidates == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return this.myCandidates.toArray(new GroovyResolveResult[this.myCandidates.size()]);
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
    }

    public boolean hasCandidates() {
        return this.myCandidates != null;
    }

    private static ClassHint.ResolveKind getResolveKind(PsiElement element) {
        if (element instanceof PsiVariable) {
            return ClassHint.ResolveKind.PROPERTY;
        }
        if (element instanceof PsiMethod) {
            return ClassHint.ResolveKind.METHOD;
        }
        if (element instanceof PsiPackage) {
            return ClassHint.ResolveKind.PACKAGE;
        }
        if (element instanceof PsiClass) {
            return ClassHint.ResolveKind.CLASS;
        }
        return null;
    }

    public String toString() {
        return "NameHint: '" + this.getName() + "', " + this.myResolveTargetKinds.toString() + ", Candidates: " + (this.myCandidates == null ? 0 : this.myCandidates.size());
    }
}

