/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.module.StdModuleTypes;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.plugins.groovy.mvc.GroovySdkWizardStepBase;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcProjectStructureDetector;

public class GroovySdkForProjectFromSourcesStep
extends GroovySdkWizardStepBase {
    private final MvcProjectStructureDetector myDetector;
    private final ProjectFromSourcesBuilder myBuilder;
    private final ProjectDescriptor myProjectDescriptor;

    public GroovySdkForProjectFromSourcesStep(MvcProjectStructureDetector detector, ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, MvcFramework framework) {
        super(framework, builder.getContext(), builder.getBaseProjectPath());
        this.myDetector = detector;
        this.myBuilder = builder;
        this.myProjectDescriptor = projectDescriptor;
    }

    @Override
    public void updateDataModel() {
        super.updateDataModel();
        ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
        for (DetectedProjectRoot root : this.myBuilder.getProjectRoots((ProjectStructureDetector)this.myDetector)) {
            ModuleDescriptor descriptor = new ModuleDescriptor(root.getDirectory(), StdModuleTypes.JAVA, Collections.emptyList());
            descriptor.addConfigurationUpdater(this.createModuleConfigurationUpdater());
            modules.add(descriptor);
        }
        this.myProjectDescriptor.setModules(modules);
    }
}

