/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.execution.configurations.ParametersList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MvcCommand {
    public static final Collection<String> ourEnvironments = Arrays.asList("prod", "test", "dev");
    private String myEnv;
    private String myCommand;
    private final ArrayList<String> myArgs = new ArrayList();
    private final ArrayList<String> myProperties = new ArrayList();

    public MvcCommand() {
    }

    public MvcCommand(String command, String ... args) {
        this.myCommand = command;
        Collections.addAll(this.myArgs, args);
    }

    public String getEnv() {
        return this.myEnv;
    }

    public void setEnv(String env) {
        this.myEnv = env;
    }

    public String getCommand() {
        return this.myCommand;
    }

    public void setCommand(String command) {
        this.myCommand = command;
    }

    public ArrayList<String> getArgs() {
        return this.myArgs;
    }

    public void setArgs(List<String> args) {
        if (args == this.myArgs) {
            return;
        }
        this.myArgs.clear();
        this.myArgs.addAll(args);
    }

    public ArrayList<String> getProperties() {
        return this.myProperties;
    }

    public void setProperties(List<String> properties) {
        if (this.myProperties == properties) {
            return;
        }
        this.myProperties.clear();
        this.myProperties.addAll(properties);
    }

    public void addToParametersList(ParametersList list) {
        if (this.myEnv != null) {
            list.add(this.myEnv);
        }
        list.addAll(this.myProperties);
        if (this.myCommand != null) {
            list.add(this.myCommand);
        }
        list.addAll(this.myArgs);
    }

    public static MvcCommand parse(String cmd) {
        int i;
        String[] args = ParametersList.parse((String)cmd);
        MvcCommand res = new MvcCommand();
        for (i = 0; res.myCommand == null && i < args.length; ++i) {
            String s = args[i];
            if (s.startsWith("-D")) {
                res.myProperties.add(s);
                continue;
            }
            if (res.myEnv == null && ourEnvironments.contains(s)) {
                res.myEnv = s;
                continue;
            }
            res.myCommand = s;
        }
        res.myArgs.addAll(Arrays.asList(args).subList(i, args.length));
        return res;
    }
}

