/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcConsole
implements Disposable {
    private static final Key<Boolean> UPDATING_BY_CONSOLE_PROCESS = Key.create((String)"UPDATING_BY_CONSOLE_PROCESS");
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.mvc.MvcConsole");
    private final ConsoleViewImpl myConsole;
    private final Project myProject;
    private final ToolWindow myToolWindow;
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final Queue<MyProcessInConsole> myProcessQueue = new LinkedList<MyProcessInConsole>();
    @NonNls
    private static final String CONSOLE_ID = "Groovy MVC Console";
    @NonNls
    public static final String TOOL_WINDOW_ID = "Console";
    private final MyKillProcessAction myKillAction = new MyKillProcessAction();
    private boolean myExecuting = false;
    private final Content myContent;

    public MvcConsole(Project project, TextConsoleBuilderFactory consoleBuilderFactory) {
        this.myProject = project;
        this.myConsole = (ConsoleViewImpl)consoleBuilderFactory.createBuilder(this.myProject).getConsole();
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(TOOL_WINDOW_ID, false, ToolWindowAnchor.BOTTOM, (Disposable)this, true);
        this.myToolWindow.setIcon(JetgroovyIcons.Groovy.Groovy_13x13);
        this.myContent = this.setUpToolWindow();
    }

    public static MvcConsole getInstance(Project project) {
        return (MvcConsole)ServiceManager.getService((Project)project, MvcConsole.class);
    }

    public static boolean isUpdatingVfsByConsoleProcess(Module module) {
        Boolean flag = (Boolean)module.getUserData(UPDATING_BY_CONSOLE_PROCESS);
        return flag != null && flag != false;
    }

    private Content setUpToolWindow() {
        RunnerLayoutUi.Factory factory = RunnerLayoutUi.Factory.getInstance((Project)this.myProject);
        RunnerLayoutUi layoutUi = factory.create("", "", "session", (Disposable)this.myProject);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.myKillAction);
        group.addSeparator();
        layoutUi.getOptions().setLeftToolbar((ActionGroup)group, "unknown");
        Content console = layoutUi.createContent(CONSOLE_ID, this.myConsole.getComponent(), "", null, null);
        layoutUi.addContent(console, 0, PlaceInGrid.right, false);
        JComponent uiComponent = layoutUi.getComponent();
        this.myPanel.add((Component)uiComponent, "Center");
        ContentManager manager = this.myToolWindow.getContentManager();
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent(uiComponent, null, true);
        manager.addContent(content);
        return content;
    }

    public void show(Runnable runnable, boolean focus) {
        Runnable r = null;
        if (runnable != null) {
            r = DisposeAwareRunnable.create((Runnable)runnable, (Project)this.myProject);
        }
        this.myToolWindow.activate(r, focus);
    }

    public static ConsoleProcessDescriptor executeProcess(Module module, GeneralCommandLine commandLine, Runnable onDone, boolean closeOnDone, String ... input) {
        return MvcConsole.getInstance(module.getProject()).executeProcess(module, commandLine, onDone, true, closeOnDone, input);
    }

    public ConsoleProcessDescriptor executeProcess(Module module, GeneralCommandLine commandLine, Runnable onDone, boolean showConsole, boolean closeOnDone, String ... input) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (module.getProject() == this.myProject);
        MyProcessInConsole process = new MyProcessInConsole(module, commandLine, onDone, showConsole, closeOnDone, input);
        if (this.isExecuting()) {
            this.myProcessQueue.add(process);
        } else {
            this.executeProcessImpl(process, true);
        }
        return process;
    }

    public boolean isExecuting() {
        return this.myExecuting;
    }

    private void executeProcessImpl(MyProcessInConsole pic, boolean toFocus) {
        OSProcessHandler handler;
        boolean modalContext;
        final Module module = pic.module;
        GeneralCommandLine commandLine = pic.commandLine;
        String[] input = pic.input;
        final boolean closeOnDone = pic.closeOnDone;
        final Runnable onDone = pic.onDone;
        assert (module.getProject() == this.myProject);
        this.myExecuting = true;
        if (module.isDisposed()) {
            return;
        }
        final ModalityState modalityState = ModalityState.current();
        boolean bl = modalContext = modalityState != ModalityState.NON_MODAL;
        if (!modalContext && pic.showConsole) {
            this.show(null, toFocus);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.myConsole.print(commandLine.getCommandLineString(), ConsoleViewContentType.SYSTEM_OUTPUT);
        try {
            Process process = commandLine.createProcess();
            handler = new OSProcessHandler(process);
            OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
            for (String s : input) {
                writer.write(s);
            }
            writer.flush();
            final Ref gotError = new Ref((Object)false);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key key) {
                    if (key == ProcessOutputTypes.STDERR) {
                        gotError.set((Object)true);
                    }
                    LOG.debug("got text: " + event.getText());
                }

                public void processTerminated(ProcessEvent event) {
                    int exitCode = event.getExitCode();
                    if (exitCode == 0 && !((Boolean)gotError.get()).booleanValue()) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (MvcConsole.this.myProject.isDisposed() || !closeOnDone) {
                                    return;
                                }
                                MvcConsole.this.myToolWindow.hide(null);
                            }
                        }, modalityState);
                    }
                }
            });
        }
        catch (Exception e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)e.getMessage(), (String)"Cannot Start Process");
                    try {
                        if (onDone != null && !module.isDisposed()) {
                            onDone.run();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Throwable)e2);
                    }
                }
            }, modalityState);
            return;
        }
        pic.setHandler(handler);
        this.myKillAction.setHandler(handler);
        MvcFramework framework = MvcFramework.getInstance(module);
        this.myToolWindow.setIcon(framework == null ? JetgroovyIcons.Groovy.Groovy_13x13 : framework.getToolWindowIcon());
        this.myContent.setDisplayName((framework == null ? "" : framework.getDisplayName() + ":") + "Executing...");
        this.myConsole.scrollToEnd();
        this.myConsole.attachToProcess((ProcessHandler)handler);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                handler.startNotify();
                handler.waitFor();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (MvcConsole.this.myProject.isDisposed()) {
                            return;
                        }
                        module.putUserData(UPDATING_BY_CONSOLE_PROCESS, (Object)true);
                        LocalFileSystem.getInstance().refresh(false);
                        module.putUserData(UPDATING_BY_CONSOLE_PROCESS, null);
                        try {
                            if (onDone != null && !module.isDisposed()) {
                                onDone.run();
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                        MvcConsole.this.myConsole.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                        MvcConsole.this.myKillAction.setHandler(null);
                        MvcConsole.this.myContent.setDisplayName("");
                        MvcConsole.this.myExecuting = false;
                        MyProcessInConsole pic = (MyProcessInConsole)MvcConsole.this.myProcessQueue.poll();
                        if (pic != null) {
                            MvcConsole.this.executeProcessImpl(pic, false);
                        }
                    }
                }, modalityState);
            }
        });
    }

    public void dispose() {
    }

    public ConsoleViewImpl getConsole() {
        return this.myConsole;
    }

    private class MyKillProcessAction
    extends AnAction {
        private OSProcessHandler myHandler;

        public MyKillProcessAction() {
            super("Kill process", "Kill process", AllIcons.Debugger.KillProcess);
            this.myHandler = null;
        }

        public void setHandler(OSProcessHandler handler) {
            this.myHandler = handler;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myHandler != null) {
                Process process = this.myHandler.getProcess();
                process.destroy();
                MvcConsole.this.myConsole.print("Process terminated", ConsoleViewContentType.ERROR_OUTPUT);
            }
        }

        public boolean isEnabled() {
            return this.myHandler != null;
        }
    }

    private static class MyProcessInConsole
    implements ConsoleProcessDescriptor {
        final Module module;
        final GeneralCommandLine commandLine;
        final Runnable onDone;
        final boolean closeOnDone;
        final boolean showConsole;
        final String[] input;
        private final List<ProcessListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        private OSProcessHandler myHandler;

        public MyProcessInConsole(Module module, GeneralCommandLine commandLine, Runnable onDone, boolean showConsole, boolean closeOnDone, String[] input) {
            this.module = module;
            this.commandLine = commandLine;
            this.onDone = onDone;
            this.closeOnDone = closeOnDone;
            this.input = input;
            this.showConsole = showConsole;
        }

        @Override
        public ConsoleProcessDescriptor addProcessListener(ProcessListener listener) {
            if (this.myHandler != null) {
                this.myHandler.addProcessListener(listener);
            } else {
                this.myListeners.add(listener);
            }
            return this;
        }

        @Override
        public ConsoleProcessDescriptor waitWith(ProgressIndicator progressIndicator) {
            if (this.myHandler != null) {
                this.doWait(progressIndicator);
            }
            return this;
        }

        private void doWait(ProgressIndicator progressIndicator) {
            while (!this.myHandler.waitFor(500L)) {
                if (!progressIndicator.isCanceled()) continue;
                this.myHandler.destroyProcess();
                break;
            }
        }

        public void setHandler(OSProcessHandler handler) {
            this.myHandler = handler;
            for (ProcessListener listener : this.myListeners) {
                handler.addProcessListener(listener);
            }
        }
    }
}

