/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.plugins.groovy.mvc.MvcConfigureNotification;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcProjectWithoutLibraryNotificator
implements StartupActivity,
DumbAware {
    public void runActivity(final Project project) {
        ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)new ReadTask(){

            public void computeInReadAction(ProgressIndicator indicator) {
                if (project.isDisposed()) {
                    return;
                }
                Pair pair = MvcProjectWithoutLibraryNotificator.findModuleWithoutLibrary(project);
                if (pair != null) {
                    final MvcFramework framework = (MvcFramework)pair.second;
                    final Module module = (Module)pair.first;
                    String name = framework.getFrameworkName();
                    String content = "<html><body>Module '" + module.getName() + "' has no " + name + " SDK. <a href='create'>Configure SDK</a></body></html>";
                    new Notification(name + ".Configure", name + " SDK not found", content, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(Notification notification, HyperlinkEvent e) {
                            if (!module.isDisposed()) {
                                MvcConfigureNotification.configure(framework, module);
                            }
                        }
                    }).notify(project);
                }
            }

            public void onCanceled(ProgressIndicator indicator) {
                ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)this);
            }
        });
    }

    private static Pair<Module, MvcFramework> findModuleWithoutLibrary(Project project) {
        MvcFramework[] frameworks = (MvcFramework[])MvcFramework.EP_NAME.getExtensions();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (MvcFramework framework : frameworks) {
                VirtualFile appRoot = framework.findAppRoot(module);
                if (appRoot == null || appRoot.findChild("application.properties") == null || framework.hasFrameworkJar(module)) continue;
                return Pair.create((Object)module, (Object)framework);
            }
        }
        return null;
    }
}

