/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcRunTargetHistoryService;
import org.jetbrains.plugins.groovy.mvc.util.MvcTargetDialogCompletionUtils;

public class MvcRunTargetDialog
extends DialogWrapper {
    private static final String GRAILS_PREFIX = "grails ";
    private JPanel contentPane;
    private JLabel myTargetLabel;
    private JPanel myFakePanel;
    private EditorTextField myVmOptionsField;
    private ModulesComboBox myModuleBox;
    private JLabel myModuleLabel;
    private JLabel myVmOptionLabel;
    private ComboBox myTargetField;
    private Module myModule;
    private final MvcFramework myFramework;
    private Action myInteractiveRunAction;

    public MvcRunTargetDialog(Module module, MvcFramework framework) {
        super(module.getProject(), true);
        this.myModule = module;
        this.myFramework = framework;
        this.$$$setupUI$$$();
        this.setTitle("Run " + framework.getDisplayName() + " target");
        this.setUpDialog();
        this.setModal(true);
        this.init();
    }

    protected Action[] createLeftSideActions() {
        boolean hasOneSupportedModule = false;
        for (Module module : ModuleManager.getInstance((Project)this.myModule.getProject()).getModules()) {
            if (module != this.myModule && !this.myFramework.hasSupport(module) || !this.myFramework.isInteractiveConsoleSupported(module)) continue;
            hasOneSupportedModule = true;
            break;
        }
        if (hasOneSupportedModule) {
            this.myInteractiveRunAction = new DialogWrapper.DialogWrapperAction("&Start Grails Console in Interactive Mode"){

                protected void doAction(ActionEvent e) {
                    MvcRunTargetDialog.this.myFramework.runInteractiveConsole(MvcRunTargetDialog.this.getSelectedModule());
                    MvcRunTargetDialog.this.doCancelAction();
                }
            };
            this.myInteractiveRunAction.setEnabled(this.myFramework.isInteractiveConsoleSupported(this.myModule));
            return new Action[]{this.myInteractiveRunAction};
        }
        return new Action[0];
    }

    private void setUpDialog() {
        this.myTargetLabel.setLabelFor((Component)this.myTargetField);
        this.myTargetField.setFocusable(true);
        this.myVmOptionLabel.setLabelFor((Component)this.myVmOptionsField);
        this.myVmOptionsField.setText(MvcRunTargetHistoryService.getInstance().getVmOptions());
        ArrayList<Module> mvcModules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)this.myModule.getProject()).getModules()) {
            if (module != this.myModule && !this.myFramework.hasSupport(module)) continue;
            mvcModules.add(module);
        }
        assert (mvcModules.contains(this.myModule));
        this.myModuleLabel.setLabelFor((Component)this.myModuleBox);
        this.myModuleBox.setModules(mvcModules);
        this.myModuleBox.setSelectedModule(this.myModule);
        this.myModuleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MvcRunTargetDialog.this.myModule = MvcRunTargetDialog.this.myModuleBox.getSelectedModule();
                if (MvcRunTargetDialog.this.myInteractiveRunAction != null) {
                    MvcRunTargetDialog.this.myInteractiveRunAction.setEnabled(MvcRunTargetDialog.this.myFramework.isInteractiveConsoleSupported(MvcRunTargetDialog.this.myModule));
                }
            }
        });
    }

    public Module getSelectedModule() {
        return this.myModule;
    }

    protected void doOKAction() {
        super.doOKAction();
        MvcRunTargetHistoryService.getInstance().addCommand(this.getSelectedText(), this.getVmOptions());
    }

    public String getVmOptions() {
        return this.myVmOptionsField.getText();
    }

    public String getSelectedText() {
        return (String)this.myTargetField.getEditor().getItem();
    }

    public String getTargetArguments() {
        String text = this.getSelectedText();
        if ((text = text.trim()).startsWith(GRAILS_PREFIX)) {
            text = text.substring(GRAILS_PREFIX.length());
        }
        return text;
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetField;
    }

    private void createUIComponents() {
        this.myTargetField = new ComboBox((Object[])MvcRunTargetHistoryService.getInstance().getHistory());
        this.myTargetField.setLightWeightPopupEnabled(false);
        StringComboboxEditor editor = new StringComboboxEditor(this.myModule.getProject(), (FileType)PlainTextFileType.INSTANCE, this.myTargetField);
        this.myTargetField.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)editor));
        this.myTargetField.setEditable(true);
        this.myTargetField.setEditor((ComboBoxEditor)editor);
        EditorTextField editorTextField = editor.getEditorComponent();
        this.myFakePanel = new JPanel(new BorderLayout());
        this.myFakePanel.add((Component)this.myTargetField, "Center");
        TextFieldCompletionProviderDumbAware vmOptionCompletionProvider = new TextFieldCompletionProviderDumbAware(){

            protected String getPrefix(String currentTextPrefix) {
                return MvcRunTargetDialog.getPrefix(currentTextPrefix);
            }

            protected void addCompletionVariants(String text, int offset, String prefix, CompletionResultSet result) {
                if (prefix.endsWith("-D")) {
                    result.addAllElements(MvcTargetDialogCompletionUtils.getSystemPropertiesVariants());
                }
            }
        };
        this.myVmOptionsField = vmOptionCompletionProvider.createEditor(this.myModule.getProject());
        new TextFieldCompletionProviderDumbAware(){

            protected String getPrefix(String currentTextPrefix) {
                return MvcRunTargetDialog.getPrefix(currentTextPrefix);
            }

            protected void addCompletionVariants(String text, int offset, String prefix, CompletionResultSet result) {
                for (LookupElement variant : MvcTargetDialogCompletionUtils.collectVariants(MvcRunTargetDialog.this.myModule, text, offset, prefix)) {
                    result.addElement(variant);
                }
            }
        }.apply(editorTextField);
        editorTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                MvcRunTargetDialog.this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)e.getDocument().getText()));
            }
        });
        this.setOKActionEnabled(false);
    }

    public static String getPrefix(String currentTextPrefix) {
        return currentTextPrefix.substring(currentTextPrefix.lastIndexOf(32) + 1);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ModulesComboBox modulesComboBox;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, "North");
        this.myTargetLabel = jLabel3 = new JLabel();
        jLabel3.setText("Command line:");
        jLabel3.setDisplayedMnemonic('C');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = this.myFakePanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(600, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel4, "Center");
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Options", (int)0, (int)0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myVmOptionLabel = jLabel2 = new JLabel();
        jLabel2.setText("VM options:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleLabel = jLabel = new JLabel();
        jLabel.setText("Module:");
        jLabel.setDisplayedMnemonic('M');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleBox = modulesComboBox = new ModulesComboBox();
        jPanel5.add((Component)modulesComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        EditorTextField editorTextField = this.myVmOptionsField;
        jPanel5.add((Component)editorTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

