/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.mvc.projectView.NodeId;

public abstract class AbstractMvcPsiNodeDescriptor
extends AbstractPsiBasedNode<NodeId> {
    public static final int FOLDER = 100;
    public static final int FILE = 110;
    public static final int CLASS = 5;
    public static final int FIELD = 7;
    public static final int METHOD = 10;
    public static final int DOMAIN_CLASSES_FOLDER = 20;
    public static final int CONTROLLERS_FOLDER = 30;
    public static final int VIEWS_FOLDER = 40;
    public static final int SERVICES_FOLDER = 50;
    public static final int CONFIG_FOLDER = 60;
    public static final int OTHER_GRAILS_APP_FOLDER = 64;
    public static final int WEB_APP_FOLDER = 65;
    public static final int SRC_FOLDERS = 70;
    public static final int TESTS_FOLDER = 80;
    public static final int TAGLIB_FOLDER = 90;
    private final Module myModule;
    private final int myWeight;

    protected AbstractMvcPsiNodeDescriptor(Module module, ViewSettings viewSettings, NodeId nodeId, int weight) {
        super(module.getProject(), (Object)nodeId, viewSettings);
        this.myModule = module;
        this.myWeight = weight;
    }

    @NonNls
    protected abstract String getTestPresentationImpl(NodeId var1, PsiElement var2);

    public final boolean contains(VirtualFile file) {
        return this.isValid() && this.containsImpl(file);
    }

    protected boolean containsImpl(VirtualFile file) {
        return super.contains(file);
    }

    protected PsiElement extractPsiFromValue() {
        NodeId nodeId = (NodeId)this.getValue();
        return nodeId != null ? nodeId.getPsiElement() : null;
    }

    public final String getTestPresentation() {
        PsiElement psi = this.extractPsiFromValue();
        if (psi == null || !psi.isValid() || !this.isValid()) {
            return "null";
        }
        return this.getTestPresentationImpl((NodeId)this.getValue(), psi);
    }

    public Module getModule() {
        return this.myModule;
    }

    public VirtualFile getVirtualFile() {
        if (!this.isValid()) {
            return null;
        }
        return PsiUtilCore.getVirtualFile((PsiElement)this.extractPsiFromValue());
    }

    protected void updateImpl(PresentationData data) {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement instanceof NavigationItem) {
            ItemPresentation presentation = ((NavigationItem)psiElement).getPresentation();
            assert (presentation != null);
            data.setPresentableText(presentation.getPresentableText());
        }
    }

    public final int getTypeSortWeight(boolean sortByType) {
        return this.myWeight;
    }

    protected boolean hasProblemFileBeneath() {
        return WolfTheProblemSolver.getInstance((Project)this.getProject()).hasProblemFilesBeneath((Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                return AbstractMvcPsiNodeDescriptor.this.contains(virtualFile);
            }
        });
    }

    public boolean isValid() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement != null && psiElement.isValid();
    }
}

