/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcModuleNode;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;

public class MvcProjectNode
extends AbstractProjectNode {
    private final MvcToolWindowDescriptor myDescriptor;

    public MvcProjectNode(Project project, ViewSettings viewSettings, MvcToolWindowDescriptor descriptor) {
        super(project, project, viewSettings);
        this.myDescriptor = descriptor;
    }

    public Collection<? extends AbstractTreeNode> getChildren() {
        List<Module> modules = MvcModuleStructureUtil.getAllModulesWithSupport(this.myProject, this.myDescriptor.getFramework());
        modules = this.myDescriptor.getFramework().reorderModulesForMvcView(modules);
        ArrayList<MvcModuleNode> nodes = new ArrayList<MvcModuleNode>();
        for (Module module : modules) {
            nodes.add(new MvcModuleNode(module, this.getSettings(), this.myDescriptor));
        }
        return nodes;
    }

    public boolean isAlwaysExpand() {
        return true;
    }

    protected AbstractTreeNode createModuleGroup(Module module) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return MvcProjectNode.createTreeNode(MvcProjectNode.class, (Project)this.getProject(), (Object)module, (ViewSettings)this.getSettings());
    }

    protected AbstractTreeNode createModuleGroupNode(ModuleGroup moduleGroup) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return MvcProjectNode.createTreeNode(MvcProjectNode.class, (Project)this.getProject(), (Object)moduleGroup, (ViewSettings)this.getSettings());
    }
}

