/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.ExceptionsTableModel;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.JavaCodeFragmentTableCellEditor;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureProcessor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureUtil;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrMethodDescriptor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterTableModel;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterTableModelItem;
import org.jetbrains.plugins.groovy.refactoring.ui.GroovyComboboxVisibilityPanel;

public class GrChangeSignatureDialog
extends ChangeSignatureDialogBase<GrParameterInfo, PsiMethod, String, GrMethodDescriptor, GrParameterTableModelItem, GrParameterTableModel> {
    private static final Logger LOG = Logger.getInstance(GrChangeSignatureDialog.class);
    private static final String INDENT = "    ";
    private ExceptionsTableModel myExceptionsModel;

    public GrChangeSignatureDialog(Project project, GrMethodDescriptor method, boolean allowDelegation, PsiElement defaultValueContext) {
        super(project, (MethodDescriptor)method, allowDelegation, defaultValueContext);
    }

    protected LanguageFileType getFileType() {
        return GroovyFileType.GROOVY_FILE_TYPE;
    }

    protected GrParameterTableModel createParametersInfoModel(GrMethodDescriptor method) {
        GrParameterList parameterList = method.getMethod().getParameterList();
        return new GrParameterTableModel((PsiElement)parameterList, this.myDefaultValueContext, this);
    }

    protected BaseRefactoringProcessor createRefactoringProcessor() {
        CanonicalTypes.Type type = this.getReturnType();
        ThrownExceptionInfo[] exceptionInfos = this.myExceptionsModel.getThrownExceptions();
        GrChangeInfoImpl info = new GrChangeInfoImpl(((GrMethodDescriptor)this.myMethod).getMethod(), (String)this.getVisibility(), type, this.getMethodName(), this.getParameters(), exceptionInfos, this.isGenerateDelegate());
        return new GrChangeSignatureProcessor(this.myProject, info);
    }

    protected List<Pair<String, JPanel>> createAdditionalPanels() {
        this.myExceptionsModel = new ExceptionsTableModel((PsiElement)((GrMethodDescriptor)this.myMethod).getMethod().getThrowsList());
        this.myExceptionsModel.setTypeInfos((PsiMethod)((GrMethodDescriptor)this.myMethod).getMethod());
        final JBTable table = new JBTable((TableModel)this.myExceptionsModel);
        table.setStriped(true);
        table.setRowHeight(20);
        table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new CodeFragmentTableCellRenderer(this.myProject));
        final JavaCodeFragmentTableCellEditor cellEditor = new JavaCodeFragmentTableCellEditor(this.myProject);
        cellEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                int row = table.getSelectedRow();
                int col = table.getSelectedColumn();
                GrChangeSignatureDialog.this.myExceptionsModel.setValueAt((Object)cellEditor.getCellEditorValue(), row, col);
                GrChangeSignatureDialog.this.updateSignature();
            }
        });
        table.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)cellEditor);
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().setSelectionInterval(0, 0);
        table.setSurrendersFocusOnKeystroke(true);
        JPanel panel = ToolbarDecorator.createDecorator((JTable)table).createPanel();
        panel.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myExceptionsModel.addTableModelListener((TableModelListener)this.mySignatureUpdater);
        ArrayList<Pair<String, JPanel>> result = new ArrayList<Pair<String, JPanel>>();
        String message = RefactoringBundle.message((String)"changeSignature.exceptions.panel.border.title");
        result.add(Pair.create((Object)message, (Object)panel));
        return result;
    }

    private CanonicalTypes.Type getReturnType() {
        PsiType returnType = null;
        try {
            if (this.myReturnTypeCodeFragment != null) {
                returnType = ((PsiTypeCodeFragment)this.myReturnTypeCodeFragment).getType();
            }
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException ignored) {
        }
        catch (PsiTypeCodeFragment.NoTypeException noTypeException) {
            // empty catch block
        }
        return returnType == null ? null : CanonicalTypes.createTypeWrapper(returnType);
    }

    protected PsiCodeFragment createReturnTypeCodeFragment() {
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)this.myProject);
        return factory.createTypeCodeFragment(((GrMethodDescriptor)this.myMethod).getReturnTypeText(), (PsiElement)((GrMethodDescriptor)this.myMethod).getMethod(), true, 1);
    }

    protected CallerChooserBase<PsiMethod> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<PsiMethod>> callback) {
        return null;
    }

    private boolean isGroovyMethodName(String name) {
        String methodText = "def " + name + "(){}";
        try {
            GrMethod method = GroovyPsiElementFactory.getInstance(this.getProject()).createMethodFromText(methodText);
            return method != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean checkType(PsiTypeCodeFragment typeCodeFragment, boolean allowEllipsis) {
        try {
            PsiType type = typeCodeFragment.getType();
            return allowEllipsis || !(type instanceof PsiEllipsisType);
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e) {
            return false;
        }
        catch (PsiTypeCodeFragment.NoTypeException e) {
            return true;
        }
    }

    protected String validateAndCommitData() {
        if (this.myReturnTypeCodeFragment != null && !GrChangeSignatureDialog.checkType((PsiTypeCodeFragment)this.myReturnTypeCodeFragment, true)) {
            return GroovyRefactoringBundle.message("return.type.is.wrong", new Object[0]);
        }
        List parameterInfos = ((GrParameterTableModel)this.myParametersTableModel).getItems();
        int newParameterCount = parameterInfos.size();
        for (int i = 0; i < newParameterCount; ++i) {
            GrParameterTableModelItem item = (GrParameterTableModelItem)((Object)parameterInfos.get(i));
            String name = ((GrParameterInfo)item.parameter).getName();
            if (!StringUtil.isJavaIdentifier((String)name)) {
                return GroovyRefactoringBundle.message("name.is.wrong", name);
            }
            if (!GrChangeSignatureDialog.checkType((PsiTypeCodeFragment)item.typeCodeFragment, i == newParameterCount - 1)) {
                return GroovyRefactoringBundle.message("type.for.parameter.is.incorrect", name);
            }
            try {
                ((GrParameterInfo)item.parameter).setType(((PsiTypeCodeFragment)item.typeCodeFragment).getType());
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                LOG.error((Throwable)e);
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                ((GrParameterInfo)item.parameter).setType(null);
            }
            String defaultValue = item.defaultValueCodeFragment.getText();
            String initializer = item.initializerCodeFragment.getText();
            if (((GrParameterInfo)item.parameter).getOldIndex() < 0 && defaultValue.trim().isEmpty() && initializer.trim().isEmpty()) {
                return GroovyRefactoringBundle.message("specify.default.value", name);
            }
            ((GrParameterInfo)item.parameter).setInitializer(initializer);
            ((GrParameterInfo)item.parameter).setDefaultValue(defaultValue);
        }
        ThrownExceptionInfo[] exceptionInfos = this.myExceptionsModel.getThrownExceptions();
        PsiTypeCodeFragment[] typeCodeFragments = this.myExceptionsModel.getTypeCodeFragments();
        for (int i = 0; i < exceptionInfos.length; ++i) {
            ThrownExceptionInfo exceptionInfo = exceptionInfos[i];
            PsiTypeCodeFragment typeCodeFragment = typeCodeFragments[i];
            try {
                PsiType type = typeCodeFragment.getType();
                if (!(type instanceof PsiClassType)) {
                    return GroovyRefactoringBundle.message("changeSignature.wrong.type.for.exception", typeCodeFragment.getText());
                }
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
                PsiClassType throwable = factory.createTypeByFQClassName("java.lang.Throwable", ((GrMethodDescriptor)this.myMethod).getMethod().getResolveScope());
                if (!throwable.isAssignableFrom(type)) {
                    return GroovyRefactoringBundle.message("changeSignature.not.throwable.type", typeCodeFragment.getText());
                }
                exceptionInfo.setType((PsiClassType)type);
                continue;
            }
            catch (PsiTypeCodeFragment.TypeSyntaxException e) {
                return GroovyRefactoringBundle.message("changeSignature.wrong.type.for.exception", typeCodeFragment.getText());
            }
            catch (PsiTypeCodeFragment.NoTypeException e) {
                return GroovyRefactoringBundle.message("changeSignature.no.type.for.exception", new Object[0]);
            }
        }
        return null;
    }

    private static String generateParameterText(GrParameterInfo info) {
        StringBuilder builder = new StringBuilder();
        String typeText = info.getTypeText();
        if (typeText.isEmpty()) {
            typeText = "def";
        }
        builder.append(typeText).append(' ');
        builder.append(info.getName());
        String initializer = info.getDefaultInitializer();
        if (!StringUtil.isEmpty((String)initializer)) {
            builder.append(" = ").append(initializer);
        }
        return builder.toString();
    }

    protected String calculateSignature() {
        String type = this.myReturnTypeCodeFragment != null ? this.myReturnTypeCodeFragment.getText().trim() : "";
        StringBuilder builder = new StringBuilder();
        builder.append((String)this.myVisibilityPanel.getVisibility()).append(' ');
        if (!type.isEmpty()) {
            builder.append(type).append(' ');
        }
        builder.append(GrChangeSignatureUtil.getNameWithQuotesIfNeeded(this.getMethodName(), this.getProject()));
        builder.append('(');
        List infos = this.getParameters();
        if (!infos.isEmpty()) {
            List paramsText = ContainerUtil.map((Collection)infos, (Function)new Function<GrParameterInfo, String>(){

                public String fun(GrParameterInfo info) {
                    return GrChangeSignatureDialog.generateParameterText(info);
                }
            });
            builder.append("\n").append(INDENT);
            builder.append(StringUtil.join((Collection)paramsText, (String)",\n    "));
            builder.append('\n');
        }
        builder.append(')');
        Object[] exceptions = this.myExceptionsModel.getTypeCodeFragments();
        if (exceptions.length > 0) {
            builder.append("\nthrows\n");
            List exceptionNames = ContainerUtil.map((Object[])exceptions, (Function)new Function<PsiTypeCodeFragment, String>(){

                public String fun(PsiTypeCodeFragment fragment) {
                    return fragment.getText();
                }
            });
            builder.append(INDENT).append(StringUtil.join((Collection)exceptionNames, (String)",\n    "));
        }
        return builder.toString();
    }

    protected VisibilityPanelBase<String> createVisibilityControl() {
        return new GroovyComboboxVisibilityPanel();
    }
}

