/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract.closure;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;

public abstract class ExtractClosureProcessorBase
extends BaseRefactoringProcessor {
    protected final GrIntroduceParameterSettings myHelper;
    private static final String EXTRACT_CLOSURE = "Extract closure";

    public ExtractClosureProcessorBase(GrIntroduceParameterSettings helper) {
        super(helper.getProject());
        this.myHelper = helper;
    }

    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new UsageViewDescriptorAdapter(){

            public PsiElement[] getElements() {
                return new PsiElement[]{ExtractClosureProcessorBase.this.myHelper.getToSearchFor()};
            }

            public String getProcessedElementsHeader() {
                return ExtractClosureProcessorBase.EXTRACT_CLOSURE;
            }
        };
    }

    protected String getCommandName() {
        return EXTRACT_CLOSURE;
    }

    public static GrClosableBlock generateClosure(GrIntroduceParameterSettings helper) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ ");
        String[] params = ExtractUtil.getParameterString(helper, true);
        if (params.length > 0) {
            for (String p : params) {
                buffer.append(p);
            }
            buffer.append("->");
        }
        if (helper.getStatements().length > 1) {
            buffer.append('\n');
        }
        ExtractUtil.generateBody(helper, false, buffer, helper.isForceReturn());
        buffer.append(" }");
        return GroovyPsiElementFactory.getInstance(helper.getProject()).createClosureFromText(buffer.toString(), helper.getToReplaceIn());
    }
}

