/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineLocalVarSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;

public class GrVariableInliner
implements InlineHandler.Inliner {
    private final GrExpression myTempExpr;

    public GrVariableInliner(GrVariable variable, InlineHandler.Settings settings) {
        GrExpression initializer;
        if (settings instanceof InlineLocalVarSettings) {
            initializer = ((InlineLocalVarSettings)settings).getInitializer();
        } else {
            initializer = variable.getInitializerGroovy();
            PsiUtil.LOG.assertTrue(initializer != null);
        }
        this.myTempExpr = GrIntroduceHandlerBase.insertExplicitCastIfNeeded(variable, initializer);
    }

    public MultiMap<PsiElement, String> getConflicts(PsiReference reference, PsiElement referenced) {
        PsiElement parent;
        GroovyResolveResult resolveResult;
        GrAssignmentExpression parent2;
        MultiMap conflicts = new MultiMap();
        GrExpression expr = (GrExpression)reference.getElement();
        if (expr.getParent() instanceof GrAssignmentExpression && expr.equals((parent2 = (GrAssignmentExpression)expr.getParent()).getLValue())) {
            conflicts.putValue((Object)expr, (Object)GroovyRefactoringBundle.message("local.varaible.is.lvalue", new Object[0]));
        }
        if (!(!(referenced instanceof GrAccessorMethod) && !(referenced instanceof GrField) || !(expr instanceof GrReferenceExpression) || !((resolveResult = ((GrReferenceExpression)expr).advancedResolve()).getElement() instanceof GrAccessorMethod) || resolveResult.isInvokedOnProperty() || (parent = expr.getParent()) instanceof GrCall && parent instanceof GrExpression)) {
            conflicts.putValue((Object)expr, (Object)GroovyRefactoringBundle.message("reference.to.accessor.0.is.used", CommonRefactoringUtil.htmlEmphasize((String)PsiFormatUtil.formatMethod((PsiMethod)((GrAccessorMethod)resolveResult.getElement()), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2))));
        }
        return conflicts;
    }

    public void inlineUsage(UsageInfo usage, PsiElement referenced) {
        GrVariableInliner.inlineReference(usage, referenced, this.myTempExpr);
    }

    static void inlineReference(UsageInfo usage, PsiElement referenced, GrExpression initializer) {
        GroovyResolveResult resolveResult;
        if (initializer == null) {
            return;
        }
        GrExpression exprToBeReplaced = (GrExpression)usage.getElement();
        if (exprToBeReplaced == null) {
            return;
        }
        if ((referenced instanceof GrAccessorMethod || referenced instanceof GrField) && exprToBeReplaced instanceof GrReferenceExpression && (resolveResult = ((GrReferenceExpression)exprToBeReplaced).advancedResolve()).getElement() instanceof GrAccessorMethod && !resolveResult.isInvokedOnProperty()) {
            PsiElement parent = exprToBeReplaced.getParent();
            if (parent instanceof GrCall && parent instanceof GrExpression) {
                exprToBeReplaced = (GrExpression)parent;
            } else {
                return;
            }
        }
        GrExpression newExpr = exprToBeReplaced.replaceWithExpression((GrExpression)initializer.copy(), true);
        Project project = usage.getProject();
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)newExpr);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        GroovyRefactoringUtil.highlightOccurrences(project, editor, new PsiElement[]{newExpr});
        WindowManager.getInstance().getStatusBar(project).setInfo(GroovyRefactoringBundle.message("press.escape.to.remove.the.highlighting", new Object[0]));
    }
}

